/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReqContext {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private Subject _subject;
    private InetAddress _remoteAddr;
    private Integer _reqID;
    private Map _storm_conf;
    private Principal realPrincipal;
    private static final Logger LOG = LoggerFactory.getLogger(ReqContext.class);
    private static final ThreadLocal<ReqContext> ctxt = new ThreadLocal<ReqContext>(){

        @Override
        protected ReqContext initialValue() {
            return new ReqContext(AccessController.getContext());
        }
    };

    public static ReqContext context() {
        return ctxt.get();
    }

    @VisibleForTesting
    public ReqContext(AccessControlContext acl_ctxt) {
        this._subject = Subject.getSubject(acl_ctxt);
        this._reqID = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(Subject sub) {
        this._subject = sub;
        this._reqID = uniqueId.incrementAndGet();
    }

    public void setRemoteAddress(InetAddress addr) {
        this._remoteAddr = addr;
    }

    public InetAddress remoteAddress() {
        return this._remoteAddr;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject subject() {
        return this._subject;
    }

    public Principal principal() {
        if (this._subject == null) {
            return null;
        }
        Set<Principal> princs = this._subject.getPrincipals();
        if (princs.size() == 0) {
            return null;
        }
        return (Principal)princs.toArray()[0];
    }

    public void setRealPrincipal(Principal realPrincipal) {
        this.realPrincipal = realPrincipal;
    }

    public Principal realPrincipal() {
        return this.realPrincipal;
    }

    public boolean isImpersonating() {
        return this.realPrincipal != null;
    }

    public Integer requestID() {
        return this._reqID;
    }
}

