/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.ITransportPlugin;
import backtype.storm.security.auth.TBackoffConnect;
import backtype.storm.security.auth.ThriftConnectionType;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cluster.Cluster;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClient.class);
    private TTransport _transport;
    protected TProtocol _protocol;
    private String hostPort;
    private String host;
    private Integer port;
    private Map<Object, Object> conf;
    private Integer timeout;
    private ThriftConnectionType type;
    private String asUser;

    public ThriftClient(Map conf, ThriftConnectionType type) throws Exception {
        this(conf, type, null, null, null, null);
    }

    public ThriftClient(Map conf, ThriftConnectionType type, Integer timeout) throws Exception {
        this(conf, type, null, null, timeout, null);
    }

    public ThriftClient(Map conf, ThriftConnectionType type, String host) {
        this(conf, type, host, null, null, null);
    }

    public ThriftClient(Map conf, ThriftConnectionType type, String host, Integer port, Integer timeout) {
        this(conf, type, host, port, timeout, null);
    }

    public ThriftClient(Map conf, ThriftConnectionType type, String host, Integer port, Integer timeout, String asUser) {
        this.timeout = timeout;
        this.conf = conf;
        this.type = type;
        this.asUser = asUser;
        this.getMaster(conf, host, port);
        this.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMasterByZk(Map conf) throws Exception {
        CuratorFramework zkobj = null;
        String masterHost = null;
        try {
            String root = String.valueOf(conf.get("storm.zookeeper.root"));
            String zkMasterDir = root + Cluster.MASTER_SUBTREE;
            zkobj = Utils.newCurator(conf, (List<String>)((List)conf.get("storm.zookeeper.servers")), conf.get("storm.zookeeper.port"), zkMasterDir);
            zkobj.start();
            if (zkobj.checkExists().forPath("/") == null) {
                throw new RuntimeException("No alive nimbus ");
            }
            masterHost = new String((byte[])zkobj.getData().forPath("/"));
            LOG.info("masterHost:" + masterHost);
            String string = masterHost;
            return string;
        }
        finally {
            if (zkobj != null) {
                zkobj.close();
                zkobj = null;
            }
        }
    }

    public void getMaster(Map conf, String host, Integer port) {
        if (!StringUtils.isBlank((String)host)) {
            this.host = host;
            if (port == null) {
                port = this.type.getPort(conf);
            }
            this.port = port;
            this.hostPort = host + ":" + port;
        } else {
            try {
                this.hostPort = ThriftClient.getMasterByZk(conf);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get master from ZK.", e);
            }
            String[] host_port = this.hostPort.split(":");
            if (host_port.length != 2) {
                throw new InvalidParameterException("Host format error: " + this.hostPort);
            }
            this.host = host_port[0];
            this.port = Integer.parseInt(host_port[1]);
        }
        if (this.host == null) {
            throw new IllegalArgumentException("host is not set");
        }
        if (this.port == null || this.port <= 0) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
    }

    public synchronized TTransport transport() {
        return this._transport;
    }

    public synchronized void reconnect() {
        this.close();
        try {
            TSocket socket = new TSocket(this.host, this.port.intValue());
            if (this.timeout != null) {
                socket.setTimeout(this.timeout.intValue());
            }
            Configuration login_conf = AuthUtils.GetConfiguration(this.conf);
            ITransportPlugin transportPlugin = AuthUtils.GetTransportPlugin(this.type, this.conf, login_conf);
            TSocket underlyingTransport = socket;
            TBackoffConnect connectionRetry = new TBackoffConnect(Utils.getInt(this.conf.get("storm.nimbus.retry.times")), Utils.getInt(this.conf.get("storm.nimbus.retry.interval.millis")), Utils.getInt(this.conf.get("storm.nimbus.retry.intervalceiling.millis")));
            this._transport = connectionRetry.doConnectWithRetry(transportPlugin, (TTransport)underlyingTransport, this.host, this.asUser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this._protocol = null;
        if (this._transport != null) {
            this._protocol = new TBinaryProtocol(this._transport);
        }
    }

    public synchronized void close() {
        if (this._transport != null) {
            this._transport.close();
            this._transport = null;
            this._protocol = null;
        }
    }
}

