/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth;

import backtype.storm.utils.Utils;
import java.util.Map;

public enum ThriftConnectionType {
    NIMBUS("nimbus.thrift.transport", "nimbus.thrift.port", null, "nimbus.thrift.threads", "nimbus.thrift.max_buffer_size"),
    DRPC("drpc.thrift.transport", "drpc.port", "drpc.queue.size", "drpc.worker.threads", "drpc.max_buffer_size"),
    DRPC_INVOCATIONS("drpc.invocations.thrift.transport", "drpc.invocations.port", null, "drpc.invocations.threads", "drpc.max_buffer_size");

    private final String _transConf;
    private final String _portConf;
    private final String _qConf;
    private final String _threadsConf;
    private final String _buffConf;

    private ThriftConnectionType(String transConf, String portConf, String qConf, String threadsConf, String buffConf) {
        this._transConf = transConf;
        this._portConf = portConf;
        this._qConf = qConf;
        this._threadsConf = threadsConf;
        this._buffConf = buffConf;
    }

    public String getTransportPlugin(Map conf) {
        String ret = (String)conf.get(this._transConf);
        if (ret == null) {
            ret = (String)conf.get("storm.thrift.transport");
        }
        return ret;
    }

    public int getPort(Map conf) {
        return Utils.getInt(conf.get(this._portConf));
    }

    public Integer getQueueSize(Map conf) {
        if (this._qConf == null) {
            return null;
        }
        return (Integer)conf.get(this._qConf);
    }

    public int getNumThreads(Map conf) {
        return Utils.getInt(conf.get(this._threadsConf));
    }

    public int getMaxBufferSize(Map conf) {
        return Utils.getInt(conf.get(this._buffConf));
    }
}

