/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.authorizer;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.IPrincipalToLocal;
import backtype.storm.security.auth.ReqContext;
import backtype.storm.security.auth.authorizer.DRPCAuthorizerBase;
import backtype.storm.utils.Utils;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCSimpleACLAuthorizer
extends DRPCAuthorizerBase {
    public static Logger LOG = LoggerFactory.getLogger(DRPCSimpleACLAuthorizer.class);
    public static final String CLIENT_USERS_KEY = "client.users";
    public static final String INVOCATION_USER_KEY = "invocation.user";
    public static final String FUNCTION_KEY = "function.name";
    protected String _aclFileName = "";
    protected IPrincipalToLocal _ptol;
    protected boolean _permitWhenMissingFunctionEntry = false;
    private volatile Map<String, AclFunctionEntry> _acl = null;
    private volatile long _lastUpdate = 0L;

    protected Map<String, AclFunctionEntry> readAclFromConfig() {
        long now = System.currentTimeMillis();
        if (now - 5000L > this._lastUpdate || this._acl == null) {
            HashMap<String, AclFunctionEntry> acl = new HashMap<String, AclFunctionEntry>();
            Map conf = Utils.findAndReadConfigFile(this._aclFileName);
            if (conf.containsKey("drpc.authorizer.acl")) {
                Map confAcl = (Map)conf.get("drpc.authorizer.acl");
                for (String function : confAcl.keySet()) {
                    Map val = (Map)confAcl.get(function);
                    Collection clientUsers = val.containsKey(CLIENT_USERS_KEY) ? (Collection)val.get(CLIENT_USERS_KEY) : null;
                    String invocationUser = val.containsKey(INVOCATION_USER_KEY) ? (String)val.get(INVOCATION_USER_KEY) : null;
                    acl.put(function, new AclFunctionEntry(clientUsers, invocationUser));
                }
            } else if (!this._permitWhenMissingFunctionEntry) {
                LOG.warn("Requiring explicit ACL entries, but none given. Therefore, all operiations will be denied.");
            }
            this._acl = acl;
            this._lastUpdate = System.currentTimeMillis();
        }
        return this._acl;
    }

    @Override
    public void prepare(Map conf) {
        Boolean isStrict = (Boolean)conf.get("drpc.authorizer.acl.strict");
        this._permitWhenMissingFunctionEntry = isStrict != null && isStrict == false;
        this._aclFileName = (String)conf.get("drpc.authorizer.acl.filename");
        this._ptol = AuthUtils.GetPrincipalToLocalPlugin(conf);
    }

    private String getUserFromContext(ReqContext context) {
        Principal princ;
        if (context != null && (princ = context.principal()) != null) {
            return princ.getName();
        }
        return null;
    }

    private String getLocalUserFromContext(ReqContext context) {
        if (context != null) {
            return this._ptol.toLocal(context.principal());
        }
        return null;
    }

    protected boolean permitClientOrInvocationRequest(ReqContext context, Map params, String fieldName) {
        Map<String, AclFunctionEntry> acl = this.readAclFromConfig();
        String function = (String)params.get(FUNCTION_KEY);
        if (function != null && !function.isEmpty()) {
            AclFunctionEntry entry = acl.get(function);
            if (entry == null && this._permitWhenMissingFunctionEntry) {
                return true;
            }
            if (entry != null) {
                Object value;
                try {
                    Field field = AclFunctionEntry.class.getDeclaredField(fieldName);
                    value = field.get(entry);
                }
                catch (Exception ex) {
                    LOG.warn("Caught Exception while accessing ACL", (Throwable)ex);
                    return false;
                }
                String principal = this.getUserFromContext(context);
                String user = this.getLocalUserFromContext(context);
                if (value == null) {
                    LOG.warn("Configuration for function '" + function + "' is " + "invalid: it should have both an invocation user " + "and a list of client users defined.");
                } else {
                    if (value instanceof Set && (((Set)value).contains(principal) || ((Set)value).contains(user))) {
                        return true;
                    }
                    if (value instanceof String && (value.equals(principal) || value.equals(user))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean permitClientRequest(ReqContext context, String operation, Map params) {
        return this.permitClientOrInvocationRequest(context, params, "clientUsers");
    }

    @Override
    protected boolean permitInvocationRequest(ReqContext context, String operation, Map params) {
        return this.permitClientOrInvocationRequest(context, params, "invocationUser");
    }

    protected class AclFunctionEntry {
        public final Set<String> clientUsers;
        public final String invocationUser;

        public AclFunctionEntry(Collection<String> clientUsers, String invocationUser) {
            this.clientUsers = clientUsers != null ? new HashSet<String>(clientUsers) : new HashSet();
            this.invocationUser = invocationUser;
        }
    }
}

