/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.authorizer;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.IAuthorizer;
import backtype.storm.security.auth.IGroupMappingServiceProvider;
import backtype.storm.security.auth.IPrincipalToLocal;
import backtype.storm.security.auth.ReqContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleACLAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleACLAuthorizer.class);
    protected Set<String> _userCommands = new HashSet<String>(Arrays.asList("submitTopology", "fileUpload", "getNimbusConf", "getClusterInfo"));
    protected Set<String> _supervisorCommands = new HashSet<String>(Arrays.asList("fileDownload"));
    protected Set<String> _topoCommands = new HashSet<String>(Arrays.asList("killTopology", "rebalance", "activate", "deactivate", "getTopologyConf", "getTopology", "getUserTopology", "getTopologyInfo", "uploadNewCredentials"));
    protected Set<String> _admins;
    protected Set<String> _supervisors;
    protected Set<String> _nimbusUsers;
    protected Set<String> _nimbusGroups;
    protected IPrincipalToLocal _ptol;
    protected IGroupMappingServiceProvider _groupMappingProvider;

    @Override
    public void prepare(Map conf) {
        this._admins = new HashSet<String>();
        this._supervisors = new HashSet<String>();
        this._nimbusUsers = new HashSet<String>();
        this._nimbusGroups = new HashSet<String>();
        if (conf.containsKey("nimbus.admins")) {
            this._admins.addAll((Collection)conf.get("nimbus.admins"));
        }
        if (conf.containsKey("nimbus.supervisor.users")) {
            this._supervisors.addAll((Collection)conf.get("nimbus.supervisor.users"));
        }
        if (conf.containsKey("nimbus.users")) {
            this._nimbusUsers.addAll((Collection)conf.get("nimbus.users"));
        }
        if (conf.containsKey("nimbus.groups")) {
            this._nimbusGroups.addAll((Collection)conf.get("nimbus.groups"));
        }
        this._ptol = AuthUtils.GetPrincipalToLocalPlugin(conf);
        this._groupMappingProvider = AuthUtils.GetGroupMappingServiceProviderPlugin(conf);
    }

    @Override
    public boolean permit(ReqContext context, String operation, Map topology_conf) {
        LOG.info("[req " + context.requestID() + "] Access " + " from: " + (context.remoteAddress() == null ? "null" : context.remoteAddress().toString()) + (context.principal() == null ? "" : " principal:" + context.principal()) + " op:" + operation + (topology_conf == null ? "" : " topoology:" + topology_conf.get("topology.name")));
        String principal = context.principal().getName();
        String user = this._ptol.toLocal(context.principal());
        HashSet<String> userGroups = new HashSet();
        if (this._groupMappingProvider != null) {
            try {
                userGroups = this._groupMappingProvider.getGroups(user);
            }
            catch (IOException e) {
                LOG.warn("Error while trying to fetch user groups", (Throwable)e);
            }
        }
        if (this._admins.contains(principal) || this._admins.contains(user)) {
            return true;
        }
        if (this._supervisors.contains(principal) || this._supervisors.contains(user)) {
            return this._supervisorCommands.contains(operation);
        }
        if (this._userCommands.contains(operation)) {
            return this._nimbusUsers.size() == 0 || this._nimbusUsers.contains(user) || this.checkUserGroupAllowed(userGroups, this._nimbusGroups) != false;
        }
        if (this._topoCommands.contains(operation)) {
            HashSet topoUsers = new HashSet();
            if (topology_conf.containsKey("topology.users")) {
                topoUsers.addAll((Collection)topology_conf.get("topology.users"));
            }
            if (topoUsers.contains(principal) || topoUsers.contains(user)) {
                return true;
            }
            HashSet<String> topoGroups = new HashSet<String>();
            if (topology_conf.containsKey("topology.groups") && topology_conf.get("topology.groups") != null) {
                topoGroups.addAll((Collection)topology_conf.get("topology.groups"));
            }
            if (this.checkUserGroupAllowed(userGroups, topoGroups).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private Boolean checkUserGroupAllowed(Set<String> userGroups, Set<String> configuredGroups) {
        if (userGroups.size() > 0 && configuredGroups.size() > 0) {
            for (String tgroup : configuredGroups) {
                if (!userGroups.contains(tgroup)) continue;
                return true;
            }
        }
        return false;
    }
}

