/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.digest;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCallbackHandler
implements CallbackHandler {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Logger LOG = LoggerFactory.getLogger(ClientCallbackHandler.class);
    private String _username = null;
    private String _password = null;

    public ClientCallbackHandler(Configuration configuration) throws IOException {
        if (configuration == null) {
            return;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry("StormClient");
        if (configurationEntries == null) {
            String errorMessage = "Could not find a 'StormClient' entry in this configuration: Client cannot start.";
            throw new IOException(errorMessage);
        }
        this._password = "";
        for (AppConfigurationEntry entry : configurationEntries) {
            if (entry.getOptions().get(USERNAME) != null) {
                this._username = (String)entry.getOptions().get(USERNAME);
            }
            if (entry.getOptions().get(PASSWORD) == null) continue;
            this._password = (String)entry.getOptions().get(PASSWORD);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback c : callbacks) {
            if (c instanceof NameCallback) {
                LOG.debug("name callback");
                NameCallback nc = (NameCallback)c;
                nc.setName(this._username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                LOG.debug("password callback");
                PasswordCallback pc = (PasswordCallback)c;
                if (this._password == null) continue;
                pc.setPassword(this._password.toCharArray());
                continue;
            }
            if (c instanceof AuthorizeCallback) {
                LOG.debug("authorization callback");
                AuthorizeCallback ac = (AuthorizeCallback)c;
                String authid = ac.getAuthenticationID();
                String authzid = ac.getAuthorizationID();
                if (authid.equals(authzid)) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzid);
                continue;
            }
            if (c instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)c;
                ((RealmCallback)c).setText(rc.getDefaultText());
                continue;
            }
            throw new UnsupportedCallbackException(c);
        }
    }
}

