/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.digest;

import backtype.storm.security.auth.SaslTransportPlugin;
import backtype.storm.security.auth.digest.ClientCallbackHandler;
import backtype.storm.security.auth.digest.ServerCallbackHandler;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestSaslTransportPlugin
extends SaslTransportPlugin {
    public static final String DIGEST = "DIGEST-MD5";
    private static final Logger LOG = LoggerFactory.getLogger(DigestSaslTransportPlugin.class);

    @Override
    protected TTransportFactory getServerTransportFactory() throws IOException {
        ServerCallbackHandler serer_callback_handler = new ServerCallbackHandler(this.login_conf);
        TSaslServerTransport.Factory factory = new TSaslServerTransport.Factory();
        factory.addServerDefinition(DIGEST, "storm_thrift_server", "localhost", null, (CallbackHandler)serer_callback_handler);
        LOG.info("SASL DIGEST-MD5 transport factory will be used");
        return factory;
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws TTransportException, IOException {
        ClientCallbackHandler client_callback_handler = new ClientCallbackHandler(this.login_conf);
        TSaslClientTransport wrapper_transport = new TSaslClientTransport(DIGEST, null, "storm_thrift_server", serverHost, null, (CallbackHandler)client_callback_handler, transport);
        wrapper_transport.open();
        LOG.debug("SASL DIGEST-MD5 client transport has been established");
        return wrapper_transport;
    }
}

