/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.kerberos;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.IAutoCredentials;
import backtype.storm.security.auth.ICredentialsRenewer;
import backtype.storm.security.auth.kerberos.ClientCallbackHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTGT
implements IAutoCredentials,
ICredentialsRenewer {
    private static final Logger LOG = LoggerFactory.getLogger(AutoTGT.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    protected static AtomicReference<KerberosTicket> kerbTicket = new AtomicReference();
    private Map conf;

    @Override
    public void prepare(Map conf) {
        this.conf = conf;
    }

    private static KerberosTicket getTGT(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            tickets = null;
            return ticket;
        }
        tickets = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateCredentials(Map<String, String> credentials) {
        try {
            Configuration login_conf = AuthUtils.GetConfiguration(this.conf);
            ClientCallbackHandler client_callback_handler = new ClientCallbackHandler(login_conf);
            Configuration.setConfiguration(login_conf);
            LoginContext lc = new LoginContext("StormClient", client_callback_handler);
            try {
                lc.login();
                Subject subject = lc.getSubject();
                KerberosTicket tgt = AutoTGT.getTGT(subject);
                if (tgt == null) {
                    throw new RuntimeException("Fail to verify user principal with section \"StormClient\" in login configuration file " + login_conf);
                }
                if (!tgt.isForwardable()) {
                    throw new RuntimeException("The TGT found is not forwardable");
                }
                if (!tgt.isRenewable()) {
                    throw new RuntimeException("The TGT found is not renewable");
                }
                LOG.info("Pushing TGT for " + tgt.getClient() + " to topology.");
                AutoTGT.saveTGT(tgt, credentials);
            }
            finally {
                lc.logout();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveTGT(KerberosTicket tgt, Map<String, String> credentials) {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bao);
            out.writeObject(tgt);
            out.flush();
            out.close();
            credentials.put("TGT", DatatypeConverter.printBase64Binary((byte[])bao.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KerberosTicket getTGT(Map<String, String> credentials) {
        KerberosTicket ret = null;
        if (credentials != null && credentials.containsKey("TGT")) {
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)credentials.get("TGT")));
                ObjectInputStream in = new ObjectInputStream(bin);
                ret = (KerberosTicket)in.readObject();
                in.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.populateSubjectWithTGT(subject, credentials);
    }

    @Override
    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.populateSubjectWithTGT(subject, credentials);
        this.loginHadoopUser(subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSubjectWithTGT(Subject subject, Map<String, String> credentials) {
        KerberosTicket tgt = AutoTGT.getTGT(credentials);
        if (tgt != null) {
            Set<Object> creds;
            Set<Object> set = creds = subject.getPrivateCredentials();
            synchronized (set) {
                Iterator<Object> iterator = creds.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!(o instanceof KerberosTicket)) continue;
                    KerberosTicket t = (KerberosTicket)o;
                    iterator.remove();
                    try {
                        t.destroy();
                    }
                    catch (DestroyFailedException e) {
                        LOG.warn("Failed to destory ticket ", (Throwable)e);
                    }
                }
                creds.add(tgt);
            }
            subject.getPrincipals().add(tgt.getClient());
            kerbTicket.set(tgt);
        } else {
            LOG.info("No TGT found in credentials");
        }
    }

    private void loginHadoopUser(Subject subject) {
        Class<?> ugi = null;
        try {
            ugi = Class.forName("org.apache.hadoop.security.UserGroupInformation");
        }
        catch (ClassNotFoundException e) {
            LOG.info("Hadoop was not found on the class path");
            return;
        }
        try {
            Method isSecEnabled = ugi.getMethod("isSecurityEnabled", new Class[0]);
            if (!((Boolean)isSecEnabled.invoke(null, new Object[0])).booleanValue()) {
                LOG.warn("Hadoop is on the classpath but not configured for security, if you want security you need to be sure that hadoop.security.authentication=kerberos in core-site.xml in your jar");
                return;
            }
            try {
                Method login = ugi.getMethod("loginUserFromSubject", Subject.class);
                login.invoke(null, subject);
            }
            catch (NoSuchMethodException me) {
                String name = AutoTGT.getTGT(subject).getClient().toString();
                LOG.warn("The Hadoop client does not have loginUserFromSubject, Trying to hack around it. This may not work...");
                Class<?> confClass = Class.forName("org.apache.hadoop.conf.Configuration");
                Constructor<?> confCons = confClass.getConstructor(new Class[0]);
                Object conf = confCons.newInstance(new Object[0]);
                Class<?> hknClass = Class.forName("org.apache.hadoop.security.HadoopKerberosName");
                Method hknSetConf = hknClass.getMethod("setConfiguration", confClass);
                hknSetConf.invoke(null, conf);
                Class<?> authMethodClass = Class.forName("org.apache.hadoop.security.UserGroupInformation$AuthenticationMethod");
                Object kerbAuthMethod = null;
                for (Object authMethod : authMethodClass.getEnumConstants()) {
                    if (!"KERBEROS".equals(authMethod.toString())) continue;
                    kerbAuthMethod = authMethod;
                    break;
                }
                Class<?> userClass = Class.forName("org.apache.hadoop.security.User");
                Constructor<?> userCons = userClass.getConstructor(String.class, authMethodClass, LoginContext.class);
                userCons.setAccessible(true);
                Object user = userCons.newInstance(name, kerbAuthMethod, null);
                subject.getPrincipals().add((Principal)user);
            }
        }
        catch (Exception e) {
            LOG.warn("Something went wrong while trying to initialize Hadoop through reflection. This version of hadoop may not be compatible.", (Throwable)e);
        }
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    @Override
    public void renew(Map<String, String> credentials, Map topologyConf) {
        KerberosTicket tgt = AutoTGT.getTGT(credentials);
        if (tgt != null) {
            long refreshTime = this.getRefreshTime(tgt);
            long now = System.currentTimeMillis();
            if (now >= refreshTime) {
                try {
                    LOG.info("Renewing TGT for " + tgt.getClient());
                    tgt.refresh();
                    AutoTGT.saveTGT(tgt, credentials);
                }
                catch (RefreshFailedException e) {
                    LOG.warn("Failed to refresh TGT", (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AutoTGT at = new AutoTGT();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("java.security.auth.login.config", args[0]);
        at.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        at.populateCredentials(creds);
        Subject s = new Subject();
        at.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
    }
}

