/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.kerberos;

import backtype.storm.security.auth.kerberos.AutoTGT;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTGTKrb5LoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(AutoTGTKrb5LoginModule.class);
    private Subject subject;
    protected KerberosTicket kerbTicket = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        LOG.debug("Acquire TGT from Cache");
        this.getKerbTicketFromCache();
        if (this.kerbTicket != null) {
            return true;
        }
        throw new LoginException("Authentication failed, the TGT not found.");
    }

    protected void getKerbTicketFromCache() {
        this.kerbTicket = AutoTGT.kerbTicket.get();
    }

    protected Principal getKerbTicketClient() {
        if (this.kerbTicket != null) {
            return this.kerbTicket.getClient();
        }
        return null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isSucceeded()) {
            return false;
        }
        if (this.subject == null || this.subject.isReadOnly()) {
            this.kerbTicket = null;
            throw new LoginException("Authentication failed because the Subject is invalid.");
        }
        this.subject.getPrivateCredentials().add(this.kerbTicket);
        this.subject.getPrincipals().add(this.getKerbTicketClient());
        LOG.debug("Commit Succeeded.");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.isSucceeded()) {
            return false;
        }
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject != null && !this.subject.isReadOnly() && this.kerbTicket != null) {
            this.subject.getPrincipals().remove(this.kerbTicket.getClient());
            this.subject.getPrivateCredentials().remove(this.kerbTicket);
        }
        this.kerbTicket = null;
        return true;
    }

    private boolean isSucceeded() {
        return this.kerbTicket != null;
    }
}

