/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.security.auth.kerberos;

import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.SaslTransportPlugin;
import backtype.storm.security.auth.kerberos.ClientCallbackHandler;
import backtype.storm.security.auth.kerberos.ServerCallbackHandler;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.server.auth.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslTransportPlugin
extends SaslTransportPlugin {
    public static final String KERBEROS = "GSSAPI";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslTransportPlugin.class);

    @Override
    public TTransportFactory getServerTransportFactory() throws IOException {
        ServerCallbackHandler server_callback_handler = new ServerCallbackHandler(this.login_conf, this.storm_conf);
        Subject subject = null;
        try {
            Configuration.setConfiguration(this.login_conf);
            Login login = new Login("StormServer", (CallbackHandler)server_callback_handler);
            subject = login.getSubject();
        }
        catch (LoginException ex) {
            LOG.error("Server failed to login in principal:" + ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            throw new RuntimeException("Fail to verify user principal with section \"StormServer\" in login configuration file " + this.login_conf);
        }
        String principal = AuthUtils.get(this.login_conf, "StormServer", "principal");
        LOG.debug("principal:" + principal);
        KerberosName serviceKerberosName = new KerberosName(principal);
        String serviceName = serviceKerberosName.getServiceName();
        String hostName = serviceKerberosName.getHostName();
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.put("javax.security.sasl.qop", "auth");
        props.put("javax.security.sasl.server.authentication", "false");
        TSaslServerTransport.Factory factory = new TSaslServerTransport.Factory();
        factory.addServerDefinition(KERBEROS, serviceName, hostName, props, (CallbackHandler)server_callback_handler);
        TUGIAssumingTransportFactory wrapFactory = new TUGIAssumingTransportFactory((TTransportFactory)factory, subject);
        LOG.info("SASL GSSAPI transport factory will be used");
        return wrapFactory;
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws TTransportException, IOException {
        ClientCallbackHandler client_callback_handler = new ClientCallbackHandler(this.login_conf);
        Login login = null;
        try {
            Configuration.setConfiguration(this.login_conf);
            login = new Login("StormClient", (CallbackHandler)client_callback_handler);
        }
        catch (LoginException ex) {
            LOG.error("Server failed to login in principal:" + ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        Subject subject = login.getSubject();
        if (subject.getPrivateCredentials(KerberosTicket.class).isEmpty()) {
            throw new RuntimeException("Fail to verify user principal with section \"StormClient\" in login configuration file " + this.login_conf);
        }
        final String principal = StringUtils.isBlank((String)asUser) ? this.getPrincipal(subject) : asUser;
        String serviceName = AuthUtils.get(this.login_conf, "StormClient", "serviceName");
        if (serviceName == null) {
            serviceName = "storm_thrift_server";
        }
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.put("javax.security.sasl.qop", "auth");
        props.put("javax.security.sasl.server.authentication", "false");
        LOG.debug("SASL GSSAPI client transport is being established");
        TSaslClientTransport sasalTransport = new TSaslClientTransport(KERBEROS, principal, serviceName, serverHost, props, null, transport);
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>((TTransport)sasalTransport){
                final /* synthetic */ TTransport val$sasalTransport;
                {
                    this.val$sasalTransport = tTransport;
                }

                @Override
                public Void run() {
                    try {
                        LOG.debug("do as:" + principal);
                        this.val$sasalTransport.open();
                    }
                    catch (Exception e) {
                        LOG.error("Client failed to open SaslClientTransport to interact with a server during session initiation: " + e, (Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        return sasalTransport;
    }

    private String getPrincipal(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null || principals.size() < 1) {
            LOG.info("No principal found in login subject");
            return null;
        }
        return ((Principal)principals.toArray()[0]).getName();
    }

    static class TUGIAssumingTransportFactory
    extends TTransportFactory {
        private final Subject subject;
        private final TTransportFactory wrapped;

        public TUGIAssumingTransportFactory(TTransportFactory wrapped, Subject subject) {
            this.wrapped = wrapped;
            this.subject = subject;
            Set<Principal> principals = subject.getPrincipals();
            if (principals.size() > 0) {
                LOG.info("Service principal:" + ((Principal)principals.toArray()[0]).getName());
            }
        }

        public TTransport getTransport(final TTransport trans) {
            try {
                return Subject.doAs(this.subject, new PrivilegedExceptionAction<TTransport>(){

                    @Override
                    public TTransport run() {
                        try {
                            return TUGIAssumingTransportFactory.this.wrapped.getTransport(trans);
                        }
                        catch (Exception e) {
                            LOG.error("Storm server failed to open transport to interact with a client during session initiation: " + e, (Throwable)e);
                            return null;
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LOG.error("Storm server experienced a PrivilegedActionException exception while creating a transport using a JAAS principal context:" + e, (Throwable)e);
                return null;
            }
        }
    }
}

