/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.GzipThriftSerializationDelegate;
import backtype.storm.serialization.SerializationDelegate;
import backtype.storm.serialization.ThriftSerializationDelegate;
import java.util.Map;

public class GzipBridgeThriftSerializationDelegate
implements SerializationDelegate {
    private ThriftSerializationDelegate defaultDelegate = new ThriftSerializationDelegate();
    private GzipThriftSerializationDelegate gzipDelegate = new GzipThriftSerializationDelegate();
    private static final byte GZIP_MAGIC_FIRST_BYTE = 31;
    private static final byte GZIP_MAGIC_SECOND_BYTE = -117;

    @Override
    public void prepare(Map stormConf) {
        this.defaultDelegate.prepare(stormConf);
        this.gzipDelegate.prepare(stormConf);
    }

    @Override
    public byte[] serialize(Object object) {
        return this.gzipDelegate.serialize(object);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        if (this.isGzipped(bytes)) {
            return this.gzipDelegate.deserialize(bytes, clazz);
        }
        return this.defaultDelegate.deserialize(bytes, clazz);
    }

    private boolean isGzipped(byte[] bytes) {
        return bytes.length > 1 && bytes[0] == 31 && bytes[1] == -117;
    }
}

