/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.ITupleDeserializer;
import backtype.storm.serialization.KryoValuesDeserializer;
import backtype.storm.serialization.SerializationFactory;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.BatchTuple;
import backtype.storm.tuple.MessageId;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.TupleImplExt;
import com.esotericsoftware.kryo.io.Input;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoTupleDeserializer
implements ITupleDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoTupleDeserializer.class);
    public static final boolean USE_RAW_PACKET = true;
    GeneralTopologyContext _context;
    KryoValuesDeserializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Input _kryoInput;

    public KryoTupleDeserializer(Map conf, GeneralTopologyContext context) {
        this._kryo = new KryoValuesDeserializer(conf);
        this._context = context;
        this._ids = new SerializationFactory.IdDictionary(context.getRawTopology());
        this._kryoInput = new Input(1);
    }

    @Override
    public Tuple deserialize(byte[] ser) {
        this._kryoInput.setBuffer(ser);
        return this.deserialize(this._kryoInput);
    }

    public Tuple deserialize(byte[] ser, int offset, int count) {
        this._kryoInput.setBuffer(ser, offset, count);
        return this.deserialize(this._kryoInput);
    }

    public Tuple deserialize(Input input) {
        int targetTaskId = 0;
        long timeStamp = 0L;
        int taskId = 0;
        int streamId = 0;
        String componentName = null;
        String streamName = null;
        MessageId id = null;
        try {
            targetTaskId = input.readInt();
            timeStamp = input.readLong();
            taskId = input.readInt(true);
            streamId = input.readInt(true);
            componentName = this._context.getComponentId(taskId);
            streamName = this._ids.getStreamName(componentName, streamId);
            id = MessageId.deserialize(input);
            List<Object> values = this._kryo.deserializeFrom(input);
            TupleImplExt tuple = new TupleImplExt(this._context, values, taskId, streamName, id);
            tuple.setTargetTaskId(targetTaskId);
            tuple.setCreationTimeStamp(timeStamp);
            return tuple;
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Deserialize error:");
            sb.append("targetTaskId:").append(targetTaskId);
            sb.append(",creationTimeStamp:").append(timeStamp);
            sb.append(",taskId:").append(taskId);
            sb.append(",streamId:").append(streamId);
            sb.append(",componentName:").append(componentName);
            sb.append(",streamName:").append(streamName);
            sb.append(",MessageId").append(id);
            LOG.info(sb.toString(), e);
            throw new RuntimeException(e);
        }
    }

    public BatchTuple deserializeBatch(byte[] ser) {
        int tupleSize;
        BatchTuple ret = new BatchTuple();
        for (int offset = 0; offset < ser.length; offset += tupleSize) {
            this._kryoInput.setBuffer(ser, offset, offset + 4);
            tupleSize = this._kryoInput.readInt();
            ret.addToBatch(this.deserialize(ser, offset += 4, offset + tupleSize));
        }
        return ret;
    }

    public static int deserializeTaskId(byte[] ser) {
        Input _kryoInput = new Input(1);
        _kryoInput.setBuffer(ser);
        int targetTaskId = _kryoInput.readInt();
        return targetTaskId;
    }
}

