/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.ITupleSerializer;
import backtype.storm.serialization.KryoValuesSerializer;
import backtype.storm.serialization.SerializationFactory;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.BatchTuple;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.TupleExt;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class KryoTupleSerializer
implements ITupleSerializer {
    KryoValuesSerializer _kryo;
    SerializationFactory.IdDictionary _ids;
    Output _kryoOut;

    public KryoTupleSerializer(Map conf, GeneralTopologyContext context) {
        this._kryo = new KryoValuesSerializer(conf);
        this._kryoOut = new Output(2000, 2000000000);
        this._ids = new SerializationFactory.IdDictionary(context.getRawTopology());
    }

    @Override
    public byte[] serialize(Tuple tuple) {
        this._kryoOut.clear();
        this.serializeTuple(this._kryoOut, tuple);
        return this._kryoOut.toBytes();
    }

    private void serializeTuple(Output output, Tuple tuple) {
        try {
            if (tuple instanceof TupleExt) {
                output.writeInt(((TupleExt)tuple).getTargetTaskId());
                output.writeLong(((TupleExt)tuple).getCreationTimeStamp());
            }
            output.writeInt(tuple.getSourceTask(), true);
            output.writeInt(this._ids.getStreamId(tuple.getSourceComponent(), tuple.getSourceStreamId()), true);
            tuple.getMessageId().serialize(output);
            this._kryo.serializeInto(tuple.getValues(), output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serializeBatch(BatchTuple batch) {
        if (batch == null || batch.currBatchSize() == 0) {
            return null;
        }
        this._kryoOut.clear();
        for (Tuple tuple : batch.getTuples()) {
            int startPos = this._kryoOut.position();
            this._kryoOut.writeInt(0);
            this.serializeTuple(this._kryoOut, tuple);
            int endPos = this._kryoOut.position();
            this._kryoOut.setPosition(startPos);
            this._kryoOut.writeInt(endPos - startPos - 4);
            this._kryoOut.setPosition(endPos);
        }
        return this._kryoOut.toBytes();
    }

    public static byte[] serialize(int targetTask) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.putInt(targetTask);
        byte[] rtn = buff.array();
        return rtn;
    }
}

