/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.SerializationFactory;
import backtype.storm.utils.ListDelegate;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class KryoValuesSerializer {
    Kryo _kryo;
    ListDelegate _delegate;
    Output _kryoOut;

    public KryoValuesSerializer(Map conf) {
        this._kryo = SerializationFactory.getKryo(conf);
        this._delegate = new ListDelegate();
        this._kryoOut = new Output(2000, 2000000000);
    }

    public void serializeInto(List<Object> values, Output out) throws IOException {
        this._delegate.setDelegate(values);
        this._kryo.writeObject(out, (Object)this._delegate);
    }

    public byte[] serialize(List<Object> values) throws IOException {
        this._kryoOut.clear();
        this.serializeInto(values, this._kryoOut);
        return this._kryoOut.toBytes();
    }

    public byte[] serializeObject(Object obj) {
        this._kryoOut.clear();
        this._kryo.writeClassAndObject(this._kryoOut, obj);
        return this._kryoOut.toBytes();
    }
}

