/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.StormTopology;
import backtype.storm.metric.api.IMetricsConsumer;
import backtype.storm.serialization.IKryoDecorator;
import backtype.storm.serialization.IKryoFactory;
import backtype.storm.serialization.types.ArrayListSerializer;
import backtype.storm.serialization.types.HashMapSerializer;
import backtype.storm.serialization.types.HashSetSerializer;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.tuple.Values;
import backtype.storm.utils.ListDelegate;
import backtype.storm.utils.Utils;
import backtype.storm.utils.WorkerClassLoader;
import carbonite.JavaBridge;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.tuple.ConsList;

public class SerializationFactory {
    public static final Logger LOG = LoggerFactory.getLogger(SerializationFactory.class);

    public static Kryo getKryo(Map conf) {
        IKryoFactory kryoFactory = (IKryoFactory)Utils.newInstance((String)conf.get("topology.kryo.factory"));
        Kryo k = kryoFactory.getKryo(conf);
        if (WorkerClassLoader.getInstance() != null) {
            k.setClassLoader((ClassLoader)WorkerClassLoader.getInstance());
        }
        k.register(byte[].class);
        String payloadSerializerName = (String)conf.get("topology.tuple.serializer");
        try {
            Class<?> serializerClass = Class.forName(payloadSerializerName, true, k.getClassLoader());
            Serializer serializer = SerializationFactory.resolveSerializerInstance(k, ListDelegate.class, serializerClass, conf);
            k.register(ListDelegate.class, serializer);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        k.register(ArrayList.class, (Serializer)new ArrayListSerializer());
        k.register(HashMap.class, (Serializer)new HashMapSerializer());
        k.register(HashSet.class, (Serializer)new HashSetSerializer());
        k.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        k.register(TransactionAttempt.class);
        k.register(Values.class);
        k.register(IMetricsConsumer.DataPoint.class);
        k.register(IMetricsConsumer.TaskInfo.class);
        k.register(ConsList.class);
        try {
            JavaBridge.registerPrimitives((Kryo)k);
            JavaBridge.registerCollections((Kryo)k);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map<String, String> registrations = SerializationFactory.normalizeKryoRegister(conf);
        kryoFactory.preRegister(k, conf);
        boolean skipMissing = (Boolean)conf.get("topology.skip.missing.kryo.registrations");
        for (String klassName : registrations.keySet()) {
            String serializerClassName = registrations.get(klassName);
            try {
                Class<?> klass = Class.forName(klassName, true, k.getClassLoader());
                Class<?> serializerClass = null;
                if (serializerClassName != null) {
                    serializerClass = Class.forName(serializerClassName, true, k.getClassLoader());
                }
                if (serializerClass == null) {
                    k.register(klass);
                    continue;
                }
                k.register(klass, SerializationFactory.resolveSerializerInstance(k, klass, serializerClass, conf));
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) {
                    LOG.info("Could not find serialization or class for " + serializerClassName + ". Skipping registration...");
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
        kryoFactory.postRegister(k, conf);
        if (conf.get("topology.kryo.decorators") != null) {
            for (String klassName : (List)conf.get("topology.kryo.decorators")) {
                try {
                    Class<?> klass = Class.forName(klassName, true, k.getClassLoader());
                    IKryoDecorator decorator = (IKryoDecorator)klass.newInstance();
                    decorator.decorate(k);
                }
                catch (ClassNotFoundException e) {
                    if (skipMissing) {
                        LOG.info("Could not find kryo decorator named " + klassName + ". Skipping registration...");
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        kryoFactory.postDecorate(k, conf);
        return k;
    }

    private static Serializer resolveSerializerInstance(Kryo k, Class superClass, Class<? extends Serializer> serializerClass, Map conf) {
        try {
            return serializerClass.getConstructor(Kryo.class, Class.class, Map.class).newInstance(k, superClass, conf);
        }
        catch (Exception ex1) {
            try {
                try {
                    return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(k, superClass);
                }
                catch (Exception ex2) {
                    try {
                        return serializerClass.getConstructor(Kryo.class, Map.class).newInstance(k, conf);
                    }
                    catch (Exception ex3) {
                        try {
                            return serializerClass.getConstructor(Kryo.class).newInstance(k);
                        }
                        catch (Exception ex4) {
                            try {
                                return serializerClass.getConstructor(Class.class, Map.class).newInstance(superClass, conf);
                            }
                            catch (Exception ex5) {
                                try {
                                    return serializerClass.getConstructor(Class.class).newInstance(superClass);
                                }
                                catch (Exception ex6) {
                                    return serializerClass.newInstance();
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + superClass.getName(), ex);
            }
        }
    }

    private static Map<String, String> normalizeKryoRegister(Map conf) {
        Object res = conf.get("topology.kryo.register");
        if (res == null) {
            return new TreeMap<String, String>();
        }
        Map ret = new HashMap();
        if (res instanceof Map) {
            ret = (Map)res;
        } else {
            for (Object o : (List)res) {
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                ret.put((String)o, null);
            }
        }
        return new TreeMap<String, String>(ret);
    }

    public static class IdDictionary {
        Map<String, Map<String, Integer>> streamNametoId = new HashMap<String, Map<String, Integer>>();
        Map<String, Map<Integer, String>> streamIdToName = new HashMap<String, Map<Integer, String>>();

        public IdDictionary(StormTopology topology) {
            ArrayList<String> componentNames = new ArrayList<String>(topology.get_spouts().keySet());
            componentNames.addAll(topology.get_bolts().keySet());
            componentNames.addAll(topology.get_state_spouts().keySet());
            for (String name : componentNames) {
                ComponentCommon common = Utils.getComponentCommon(topology, name);
                ArrayList<String> streams = new ArrayList<String>(common.get_streams().keySet());
                this.streamNametoId.put(name, IdDictionary.idify(streams));
                this.streamIdToName.put(name, Utils.reverseMap(this.streamNametoId.get(name)));
            }
        }

        public int getStreamId(String component, String stream) {
            return this.streamNametoId.get(component).get(stream);
        }

        public String getStreamName(String component, int stream) {
            return this.streamIdToName.get(component).get(stream);
        }

        private static Map<String, Integer> idify(List<String> names) {
            Collections.sort(names);
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            int i = 1;
            for (String name : names) {
                ret.put(name, i);
                ++i;
            }
            return ret;
        }
    }
}

