/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.task;

import backtype.storm.generated.StormTopology;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.Fields;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class WorkerTopologyContext
extends GeneralTopologyContext {
    public static final String SHARED_EXECUTOR = "executor";
    private Integer _workerPort;
    private List<Integer> _workerTasks;
    private String _codeDir;
    private String _pidDir;
    Map<String, Object> _userResources;
    Map<String, Object> _defaultResources;

    public WorkerTopologyContext(StormTopology topology, Map stormConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources) {
        super(topology, stormConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId);
        this._codeDir = codeDir;
        this._defaultResources = defaultResources;
        this._userResources = userResources;
        try {
            this._pidDir = pidDir != null ? new File(pidDir).getCanonicalPath() : null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get canonical path for " + this._pidDir, e);
        }
        this._workerPort = workerPort;
        this._workerTasks = workerTasks;
    }

    public List<Integer> getThisWorkerTasks() {
        return this._workerTasks;
    }

    public Integer getThisWorkerPort() {
        return this._workerPort;
    }

    public void setThisWorkerTasks(List<Integer> workerTasks) {
        this._workerTasks = workerTasks;
    }

    public String getCodeDir() {
        return this._codeDir;
    }

    public String getPIDDir() {
        return this._pidDir;
    }

    public Object getResource(String name) {
        return this._userResources.get(name);
    }

    public ExecutorService getSharedExecutor() {
        return (ExecutorService)this._defaultResources.get(SHARED_EXECUTOR);
    }
}

