/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.metric.api.IMetricsConsumer;
import backtype.storm.task.IErrorReporter;
import backtype.storm.task.TopologyContext;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;

public class ForwardingMetricsConsumer
implements IMetricsConsumer {
    String host;
    int port;
    Socket socket;
    OutputStream out;

    @Override
    public void prepare(Map stormConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        String[] parts = ((String)registrationArgument).split(":", 2);
        this.host = parts[0];
        this.port = Integer.valueOf(parts[1]);
        try {
            this.socket = new Socket(this.host, this.port);
            this.out = this.socket.getOutputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        StringBuilder sb = new StringBuilder();
        String header = taskInfo.timestamp + "\t" + taskInfo.srcWorkerHost + ":" + taskInfo.srcWorkerPort + "\t" + taskInfo.srcTaskId + "\t" + taskInfo.srcComponentId + "\t";
        sb.append(header);
        for (IMetricsConsumer.DataPoint p : dataPoints) {
            sb.delete(header.length(), sb.length());
            sb.append(p.name).append("\t").append(p.value).append("\n");
            try {
                this.out.write(sb.toString().getBytes());
                this.out.flush();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void cleanup() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

