/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBatchBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class KeyedCountingBatchBolt
extends BaseBatchBolt {
    BatchOutputCollector _collector;
    Object _id;
    Map<Object, Integer> _counts = new HashMap<Object, Integer>();

    @Override
    public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, Object id) {
        this._collector = collector;
        this._id = id;
    }

    @Override
    public void execute(Tuple tuple) {
        Object key = tuple.getValue(1);
        int curr = Utils.get(this._counts, key, 0);
        this._counts.put(key, curr + 1);
    }

    @Override
    public void finishBatch() {
        for (Object key : this._counts.keySet()) {
            this._collector.emit(new Values(this._id, key, this._counts.get(key)));
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("tx", "key", "count"));
    }
}

