/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.Config;
import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.MemoryTransactionalSpout;
import backtype.storm.testing.MemoryTransactionalSpoutMeta;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.transactional.partitioned.IOpaquePartitionedTransactionalSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.RegisteredGlobalState;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpaqueMemoryTransactionalSpout
implements IOpaquePartitionedTransactionalSpout<MemoryTransactionalSpoutMeta> {
    public static String TX_FIELD = MemoryTransactionalSpout.class.getName() + "/id";
    private String _id;
    private String _finishedPartitionsId;
    private String _disabledId;
    private int _takeAmt;
    private Fields _outFields;

    public OpaqueMemoryTransactionalSpout(Map<Integer, List<List<Object>>> partitions, Fields outFields, int takeAmt) {
        this._id = RegisteredGlobalState.registerState(partitions);
        Map finished = Collections.synchronizedMap(new HashMap());
        this._finishedPartitionsId = RegisteredGlobalState.registerState(finished);
        Map disabled = Collections.synchronizedMap(new HashMap());
        this._disabledId = RegisteredGlobalState.registerState(disabled);
        this._takeAmt = takeAmt;
        this._outFields = outFields;
    }

    public void setDisabled(Integer partition, boolean disabled) {
        this.getDisabledStatuses().put(partition, disabled);
    }

    public boolean isExhaustedTuples() {
        Map<Integer, Boolean> statuses = this.getFinishedStatuses();
        for (Integer partition : this.getQueues().keySet()) {
            if (statuses.containsKey(partition) && this.getFinishedStatuses().get(partition).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IOpaquePartitionedTransactionalSpout.Emitter<MemoryTransactionalSpoutMeta> getEmitter(Map conf, TopologyContext context) {
        return new Emitter(conf);
    }

    @Override
    public IOpaquePartitionedTransactionalSpout.Coordinator getCoordinator(Map conf, TopologyContext context) {
        return new Coordinator();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        ArrayList<String> toDeclare = new ArrayList<String>(this._outFields.toList());
        toDeclare.add(0, TX_FIELD);
        declarer.declare(new Fields(toDeclare));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.registerSerialization(MemoryTransactionalSpoutMeta.class);
        return conf;
    }

    public void startup() {
        this.getFinishedStatuses().clear();
    }

    public void cleanup() {
        RegisteredGlobalState.clearState(this._id);
        RegisteredGlobalState.clearState(this._finishedPartitionsId);
    }

    private Map<Integer, List<List<Object>>> getQueues() {
        return (Map)RegisteredGlobalState.getState(this._id);
    }

    private Map<Integer, Boolean> getFinishedStatuses() {
        return (Map)RegisteredGlobalState.getState(this._finishedPartitionsId);
    }

    private Map<Integer, Boolean> getDisabledStatuses() {
        return (Map)RegisteredGlobalState.getState(this._disabledId);
    }

    class Emitter
    implements IOpaquePartitionedTransactionalSpout.Emitter<MemoryTransactionalSpoutMeta> {
        Integer _maxSpoutPending;
        Map<Integer, Integer> _emptyPartitions = new HashMap<Integer, Integer>();

        public Emitter(Map conf) {
            Object c = conf.get("topology.max.spout.pending");
            this._maxSpoutPending = c == null ? Integer.valueOf(1) : Utils.getInt(c);
        }

        @Override
        public MemoryTransactionalSpoutMeta emitPartitionBatch(TransactionAttempt tx, BatchOutputCollector collector, int partition, MemoryTransactionalSpoutMeta lastPartitionMeta) {
            if (!Boolean.FALSE.equals(OpaqueMemoryTransactionalSpout.this.getDisabledStatuses().get(partition))) {
                int index = lastPartitionMeta == null ? 0 : lastPartitionMeta.index + lastPartitionMeta.amt;
                List queue = (List)OpaqueMemoryTransactionalSpout.this.getQueues().get(partition);
                int total = queue.size();
                int left = total - index;
                int toTake = Math.min(left, OpaqueMemoryTransactionalSpout.this._takeAmt);
                MemoryTransactionalSpoutMeta ret = new MemoryTransactionalSpoutMeta(index, toTake);
                for (int i = ret.index; i < ret.index + ret.amt; ++i) {
                    ArrayList<Object> toEmit = new ArrayList<Object>((Collection)queue.get(i));
                    toEmit.add(0, tx);
                    collector.emit(toEmit);
                }
                if (toTake == 0) {
                    int curr = Utils.get(this._emptyPartitions, partition, 0) + 1;
                    this._emptyPartitions.put(partition, curr);
                    if (curr > this._maxSpoutPending) {
                        OpaqueMemoryTransactionalSpout.this.getFinishedStatuses().put(partition, true);
                    }
                }
                return ret;
            }
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public int numPartitions() {
            return OpaqueMemoryTransactionalSpout.this.getQueues().size();
        }
    }

    class Coordinator
    implements IOpaquePartitionedTransactionalSpout.Coordinator {
        Coordinator() {
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

