/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.TestWordCounter;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAggregatesCounter
extends BaseRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(TestWordCounter.class);
    Map<String, Integer> _counts;
    OutputCollector _collector;

    @Override
    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
        this._counts = new HashMap<String, Integer>();
    }

    @Override
    public void execute(Tuple input) {
        String word = (String)input.getValues().get(0);
        int count = (Integer)input.getValues().get(1);
        this._counts.put(word, count);
        int globalCount = 0;
        for (String w : this._counts.keySet()) {
            globalCount += this._counts.get(w).intValue();
        }
        this._collector.emit(Utils.tuple(globalCount));
        this._collector.ack(input);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("agg-global"));
    }
}

