/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.testing;

import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWordCounter
extends BaseBasicBolt {
    public static Logger LOG = LoggerFactory.getLogger(TestWordCounter.class);
    Map<String, Integer> _counts;

    @Override
    public void prepare(Map stormConf, TopologyContext context) {
        this._counts = new HashMap<String, Integer>();
    }

    @Override
    public void execute(Tuple input, BasicOutputCollector collector) {
        String word = (String)input.getValues().get(0);
        int count = 0;
        if (this._counts.containsKey(word)) {
            count = this._counts.get(word);
        }
        this._counts.put(word, ++count);
        collector.emit(Utils.tuple(word, count));
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("word", "count"));
    }
}

