/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.NullStruct;
import backtype.storm.generated.SpoutSpec;
import backtype.storm.generated.StateSpoutSpec;
import backtype.storm.generated.StormTopology;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.grouping.PartialKeyGrouping;
import backtype.storm.topology.BaseConfigurationDeclarer;
import backtype.storm.topology.BasicBoltExecutor;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.ComponentConfigurationDeclarer;
import backtype.storm.topology.ControlBoltExecutor;
import backtype.storm.topology.ControlSpoutExecutor;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IComponent;
import backtype.storm.topology.IControlBolt;
import backtype.storm.topology.IControlSpout;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.IRichStateSpout;
import backtype.storm.topology.OutputFieldsGetter;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONValue;

public class TopologyBuilder {
    private Map<String, IRichBolt> _bolts = new HashMap<String, IRichBolt>();
    private Map<String, IRichSpout> _spouts = new HashMap<String, IRichSpout>();
    private Map<String, ComponentCommon> _commons = new HashMap<String, ComponentCommon>();
    private Map<String, StateSpoutSpec> _stateSpouts = new HashMap<String, StateSpoutSpec>();

    public StormTopology createTopology() {
        ComponentCommon common;
        HashMap<String, Bolt> boltSpecs = new HashMap<String, Bolt>();
        HashMap<String, SpoutSpec> spoutSpecs = new HashMap<String, SpoutSpec>();
        for (String boltId : this._bolts.keySet()) {
            IRichBolt bolt = this._bolts.get(boltId);
            common = this.getComponentCommon(boltId, bolt);
            boltSpecs.put(boltId, new Bolt(ComponentObject.serialized_java(Utils.javaSerialize(bolt)), common));
        }
        for (String spoutId : this._spouts.keySet()) {
            IRichSpout spout = this._spouts.get(spoutId);
            common = this.getComponentCommon(spoutId, spout);
            spoutSpecs.put(spoutId, new SpoutSpec(ComponentObject.serialized_java(Utils.javaSerialize(spout)), common));
        }
        return new StormTopology(spoutSpecs, boltSpecs, new HashMap<String, StateSpoutSpec>());
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt, Number parallelism_hint) {
        this.validateUnusedId(id);
        this.initCommon(id, bolt, parallelism_hint);
        this._bolts.put(id, bolt);
        return new BoltGetter(id);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt, Number parallelism_hint) {
        return this.setBolt(id, new BasicBoltExecutor(bolt), parallelism_hint);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout) {
        return this.setSpout(id, spout, null);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout, Number parallelism_hint) {
        this.validateUnusedId(id);
        this.initCommon(id, spout, parallelism_hint);
        this._spouts.put(id, spout);
        return new SpoutGetter(id);
    }

    public SpoutDeclarer setSpout(String id, IControlSpout spout) {
        return this.setSpout(id, spout, null);
    }

    public SpoutDeclarer setSpout(String id, IControlSpout spout, Number parallelism_hint) {
        return this.setSpout(id, new ControlSpoutExecutor(spout), parallelism_hint);
    }

    public BoltDeclarer setBolt(String id, IControlBolt bolt, Number parallelism_hint) {
        return this.setBolt(id, new ControlBoltExecutor(bolt), parallelism_hint);
    }

    public BoltDeclarer setBolt(String id, IControlBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public void setStateSpout(String id, IRichStateSpout stateSpout) {
        this.setStateSpout(id, stateSpout, null);
    }

    public void setStateSpout(String id, IRichStateSpout stateSpout, Number parallelism_hint) {
        this.validateUnusedId(id);
    }

    private void validateUnusedId(String id) {
        if (this._bolts.containsKey(id)) {
            throw new IllegalArgumentException("Bolt has already been declared for id " + id);
        }
        if (this._spouts.containsKey(id)) {
            throw new IllegalArgumentException("Spout has already been declared for id " + id);
        }
        if (this._stateSpouts.containsKey(id)) {
            throw new IllegalArgumentException("State spout has already been declared for id " + id);
        }
    }

    private ComponentCommon getComponentCommon(String id, IComponent component) {
        ComponentCommon ret = new ComponentCommon(this._commons.get(id));
        OutputFieldsGetter getter = new OutputFieldsGetter();
        component.declareOutputFields(getter);
        ret.set_streams(getter.getFieldsDeclaration());
        return ret;
    }

    private void initCommon(String id, IComponent component, Number parallelism) {
        ComponentCommon common = new ComponentCommon();
        common.set_inputs(new HashMap<GlobalStreamId, Grouping>());
        if (parallelism != null) {
            common.set_parallelism_hint(parallelism.intValue());
        } else {
            common.set_parallelism_hint(1);
        }
        Map<String, Object> conf = component.getComponentConfiguration();
        if (conf != null) {
            common.set_json_conf(JSONValue.toJSONString(conf));
        }
        this._commons.put(id, common);
    }

    private static Map parseJson(String json) {
        if (json == null) {
            return new HashMap();
        }
        return (Map)JSONValue.parse((String)json);
    }

    private static String mergeIntoJson(Map into, Map newMap) {
        HashMap res = new HashMap(into);
        if (newMap != null) {
            res.putAll(newMap);
        }
        return JSONValue.toJSONString(res);
    }

    protected class BoltGetter
    extends ConfigGetter<BoltDeclarer>
    implements BoltDeclarer {
        private String _boltId;

        public BoltGetter(String boltId) {
            super(boltId);
            this._boltId = boltId;
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, Fields fields) {
            return this.fieldsGrouping(componentId, "default", fields);
        }

        @Override
        public BoltDeclarer fieldsGrouping(String componentId, String streamId, Fields fields) {
            return this.grouping(componentId, streamId, Grouping.fields(fields.toList()));
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId) {
            return this.globalGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer globalGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.fields(new ArrayList<String>()));
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId) {
            return this.shuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer shuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId) {
            return this.localOrShuffleGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.local_or_shuffle(new NullStruct()));
        }

        @Override
        public BoltDeclarer localFirstGrouping(String componentId) {
            return this.localFirstGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer localFirstGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.localFirst(new NullStruct()));
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId) {
            return this.noneGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer noneGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.none(new NullStruct()));
        }

        @Override
        public BoltDeclarer allGrouping(String componentId) {
            return this.allGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer allGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.all(new NullStruct()));
        }

        @Override
        public BoltDeclarer directGrouping(String componentId) {
            return this.directGrouping(componentId, "default");
        }

        @Override
        public BoltDeclarer directGrouping(String componentId, String streamId) {
            return this.grouping(componentId, streamId, Grouping.direct(new NullStruct()));
        }

        private BoltDeclarer grouping(String componentId, String streamId, Grouping grouping) {
            ((ComponentCommon)TopologyBuilder.this._commons.get(this._boltId)).put_to_inputs(new GlobalStreamId(componentId, streamId), grouping);
            return this;
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, CustomStreamGrouping grouping) {
            return this.customGrouping(componentId, "default", grouping);
        }

        @Override
        public BoltDeclarer customGrouping(String componentId, String streamId, CustomStreamGrouping grouping) {
            return this.grouping(componentId, streamId, Grouping.custom_serialized(Utils.javaSerialize(grouping)));
        }

        @Override
        public BoltDeclarer grouping(GlobalStreamId id, Grouping grouping) {
            return this.grouping(id.get_componentId(), id.get_streamId(), grouping);
        }
    }

    protected class SpoutGetter
    extends ConfigGetter<SpoutDeclarer>
    implements SpoutDeclarer {
        public SpoutGetter(String id) {
            super(id);
        }
    }

    protected class ConfigGetter<T extends ComponentConfigurationDeclarer>
    extends BaseConfigurationDeclarer<T> {
        String _id;

        public ConfigGetter(String id) {
            this._id = id;
        }

        @Override
        public T addConfigurations(Map conf) {
            if (conf != null && conf.containsKey("topology.kryo.register")) {
                throw new IllegalArgumentException("Cannot set serializations for a component using fluent API");
            }
            String currConf = ((ComponentCommon)TopologyBuilder.this._commons.get(this._id)).get_json_conf();
            ((ComponentCommon)TopologyBuilder.this._commons.get(this._id)).set_json_conf(TopologyBuilder.mergeIntoJson(TopologyBuilder.parseJson(currConf), conf));
            return (T)this;
        }
    }
}

