/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.transactional;

import backtype.storm.coordination.BatchOutputCollectorImpl;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.transactional.ICommitterTransactionalSpout;
import backtype.storm.transactional.ITransactionalSpout;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.transactional.TransactionalSpoutCoordinator;
import backtype.storm.tuple.Tuple;
import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalSpoutBatchExecutor
implements IRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(TransactionalSpoutBatchExecutor.class);
    BatchOutputCollectorImpl _collector;
    ITransactionalSpout _spout;
    ITransactionalSpout.Emitter _emitter;
    TreeMap<BigInteger, TransactionAttempt> _activeTransactions = new TreeMap();

    public TransactionalSpoutBatchExecutor(ITransactionalSpout spout) {
        this._spout = spout;
    }

    @Override
    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this._collector = new BatchOutputCollectorImpl(collector);
        this._emitter = this._spout.getEmitter(conf, context);
    }

    @Override
    public void execute(Tuple input) {
        TransactionAttempt attempt = (TransactionAttempt)input.getValue(0);
        try {
            if (input.getSourceStreamId().equals(TransactionalSpoutCoordinator.TRANSACTION_COMMIT_STREAM_ID)) {
                if (attempt.equals(this._activeTransactions.get(attempt.getTransactionId()))) {
                    ((ICommitterTransactionalSpout.Emitter)this._emitter).commit(attempt);
                    this._activeTransactions.remove(attempt.getTransactionId());
                    this._collector.ack(input);
                } else {
                    this._collector.fail(input);
                }
            } else {
                this._emitter.emitBatch(attempt, input.getValue(1), this._collector);
                this._activeTransactions.put(attempt.getTransactionId(), attempt);
                this._collector.ack(input);
                BigInteger committed = (BigInteger)input.getValue(2);
                if (committed != null) {
                    this._activeTransactions.headMap(committed).clear();
                    this._emitter.cleanupBefore(committed);
                }
            }
        }
        catch (FailedException e) {
            LOG.warn("Failed to emit batch for transaction", (Throwable)e);
            this._collector.fail(input);
        }
    }

    @Override
    public void cleanup() {
        this._emitter.close();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._spout.declareOutputFields(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._spout.getComponentConfiguration();
    }
}

