/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.transactional;

import backtype.storm.Constants;
import backtype.storm.coordination.BatchBoltExecutor;
import backtype.storm.coordination.CoordinatedBolt;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.StormTopology;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.grouping.PartialKeyGrouping;
import backtype.storm.topology.BaseConfigurationDeclarer;
import backtype.storm.topology.BasicBoltExecutor;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.InputDeclarer;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.transactional.ICommitter;
import backtype.storm.transactional.ICommitterTransactionalSpout;
import backtype.storm.transactional.ITransactionalSpout;
import backtype.storm.transactional.TransactionalSpoutBatchExecutor;
import backtype.storm.transactional.TransactionalSpoutCoordinator;
import backtype.storm.transactional.partitioned.IOpaquePartitionedTransactionalSpout;
import backtype.storm.transactional.partitioned.IPartitionedTransactionalSpout;
import backtype.storm.transactional.partitioned.OpaquePartitionedTransactionalSpoutExecutor;
import backtype.storm.transactional.partitioned.PartitionedTransactionalSpoutExecutor;
import backtype.storm.tuple.Fields;
import com.alibaba.jstorm.client.ConfigExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class TransactionalTopologyBuilder {
    String _id;
    String _spoutId;
    ITransactionalSpout _spout;
    Map<String, Component> _bolts = new HashMap<String, Component>();
    Integer _spoutParallelism;
    List<Map> _spoutConfs = new ArrayList<Map>();

    public TransactionalTopologyBuilder(String id, String spoutId, ITransactionalSpout spout, Number spoutParallelism) {
        this._id = id;
        this._spoutId = spoutId;
        this._spout = spout;
        this._spoutParallelism = spoutParallelism == null ? null : Integer.valueOf(spoutParallelism.intValue());
    }

    public TransactionalTopologyBuilder(String id, String spoutId, ITransactionalSpout spout) {
        this(id, spoutId, spout, null);
    }

    public TransactionalTopologyBuilder(String id, String spoutId, IPartitionedTransactionalSpout spout, Number spoutParallelism) {
        this(id, spoutId, new PartitionedTransactionalSpoutExecutor(spout), spoutParallelism);
    }

    public TransactionalTopologyBuilder(String id, String spoutId, IPartitionedTransactionalSpout spout) {
        this(id, spoutId, spout, null);
    }

    public TransactionalTopologyBuilder(String id, String spoutId, IOpaquePartitionedTransactionalSpout spout, Number spoutParallelism) {
        this(id, spoutId, new OpaquePartitionedTransactionalSpoutExecutor(spout), spoutParallelism);
    }

    public TransactionalTopologyBuilder(String id, String spoutId, IOpaquePartitionedTransactionalSpout spout) {
        this(id, spoutId, spout, null);
    }

    public SpoutDeclarer getSpoutDeclarer() {
        return new SpoutDeclarerImpl();
    }

    public BoltDeclarer setBolt(String id, IBatchBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IBatchBolt bolt, Number parallelism) {
        return this.setBolt(id, new BatchBoltExecutor(bolt), parallelism, bolt instanceof ICommitter);
    }

    public BoltDeclarer setCommitterBolt(String id, IBatchBolt bolt) {
        return this.setCommitterBolt(id, bolt, null);
    }

    public BoltDeclarer setCommitterBolt(String id, IBatchBolt bolt, Number parallelism) {
        return this.setBolt(id, new BatchBoltExecutor(bolt), parallelism, true);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt, Number parallelism) {
        return this.setBolt(id, new BasicBoltExecutor(bolt), parallelism, false);
    }

    private BoltDeclarer setBolt(String id, IRichBolt bolt, Number parallelism, boolean committer) {
        Integer p = null;
        if (parallelism != null) {
            p = parallelism.intValue();
        }
        Component component = new Component(bolt, p, committer);
        this._bolts.put(id, component);
        return new BoltDeclarerImpl(component);
    }

    public TopologyBuilder buildTopologyBuilder() {
        System.setProperty(ConfigExtension.TASK_BATCH_TUPLE, "false");
        String coordinator = this._spoutId + "/coordinator";
        TopologyBuilder builder = new TopologyBuilder();
        SpoutDeclarer declarer = builder.setSpout(coordinator, new TransactionalSpoutCoordinator(this._spout));
        for (Map conf : this._spoutConfs) {
            declarer.addConfigurations(conf);
        }
        declarer.addConfiguration("topology.transactional.id", this._id);
        BoltDeclarer emitterDeclarer = (BoltDeclarer)((BoltDeclarer)builder.setBolt(this._spoutId, new CoordinatedBolt(new TransactionalSpoutBatchExecutor(this._spout), null, null), (Number)this._spoutParallelism).allGrouping(coordinator, TransactionalSpoutCoordinator.TRANSACTION_BATCH_STREAM_ID)).addConfiguration("topology.transactional.id", this._id);
        if (this._spout instanceof ICommitterTransactionalSpout) {
            emitterDeclarer.allGrouping(coordinator, TransactionalSpoutCoordinator.TRANSACTION_COMMIT_STREAM_ID);
        }
        for (String id : this._bolts.keySet()) {
            Component component = this._bolts.get(id);
            HashMap<String, CoordinatedBolt.SourceArgs> coordinatedArgs = new HashMap<String, CoordinatedBolt.SourceArgs>();
            for (String c : this.componentBoltSubscriptions(component)) {
                coordinatedArgs.put(c, CoordinatedBolt.SourceArgs.all());
            }
            CoordinatedBolt.IdStreamSpec idSpec = null;
            if (component.committer) {
                idSpec = CoordinatedBolt.IdStreamSpec.makeDetectSpec(coordinator, TransactionalSpoutCoordinator.TRANSACTION_COMMIT_STREAM_ID);
            }
            BoltDeclarer input = builder.setBolt(id, new CoordinatedBolt(component.bolt, coordinatedArgs, idSpec), (Number)component.parallelism);
            for (Map conf : component.componentConfs) {
                input.addConfigurations(conf);
            }
            for (String c : this.componentBoltSubscriptions(component)) {
                input.directGrouping(c, Constants.COORDINATED_STREAM_ID);
            }
            for (InputDeclaration d : component.declarations) {
                d.declare(input);
            }
            if (!component.committer) continue;
            input.allGrouping(coordinator, TransactionalSpoutCoordinator.TRANSACTION_COMMIT_STREAM_ID);
        }
        return builder;
    }

    public StormTopology buildTopology() {
        return this.buildTopologyBuilder().createTopology();
    }

    private Set<String> componentBoltSubscriptions(Component component) {
        HashSet<String> ret = new HashSet<String>();
        for (InputDeclaration d : component.declarations) {
            ret.add(d.getComponent());
        }
        return ret;
    }

    private class BoltDeclarerImpl
    extends BaseConfigurationDeclarer<BoltDeclarer>
    implements BoltDeclarer {
        Component _component;

        public BoltDeclarerImpl(Component component) {
            this._component = component;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, fields);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final String streamId, final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, streamId, fields);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localFirstGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localFirstGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localFirstGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localFirstGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final String streamId, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, streamId, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer grouping(final GlobalStreamId stream, final Grouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.grouping(stream, grouping);
                }

                @Override
                public String getComponent() {
                    return stream.get_componentId();
                }
            });
            return this;
        }

        private void addDeclaration(InputDeclaration declaration) {
            this._component.declarations.add(declaration);
        }

        @Override
        public BoltDeclarer addConfigurations(Map conf) {
            this._component.componentConfs.add(conf);
            return this;
        }
    }

    private class SpoutDeclarerImpl
    extends BaseConfigurationDeclarer<SpoutDeclarer>
    implements SpoutDeclarer {
        private SpoutDeclarerImpl() {
        }

        @Override
        public SpoutDeclarer addConfigurations(Map conf) {
            TransactionalTopologyBuilder.this._spoutConfs.add(conf);
            return this;
        }
    }

    private static interface InputDeclaration {
        public void declare(InputDeclarer var1);

        public String getComponent();
    }

    private static class Component {
        public IRichBolt bolt;
        public Integer parallelism;
        public List<InputDeclaration> declarations = new ArrayList<InputDeclaration>();
        public List<Map> componentConfs = new ArrayList<Map>();
        public boolean committer;

        public Component(IRichBolt bolt, Integer parallelism, boolean committer) {
            this.bolt = bolt;
            this.parallelism = parallelism;
            this.committer = committer;
        }
    }
}

