/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.tuple;

import backtype.storm.tuple.ITupleExt;
import backtype.storm.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BatchTuple
implements ITupleExt {
    private int targetTaskId;
    private List<Tuple> batch = new ArrayList<Tuple>();
    private int batchSize;

    public BatchTuple() {
    }

    public BatchTuple(int targetTaskId, int batchSize) {
        this.targetTaskId = targetTaskId;
        this.batchSize = batchSize;
    }

    public void addToBatch(Tuple tuple) {
        this.batch.add(tuple);
    }

    public boolean isBatchFull() {
        boolean ret = false;
        if (this.batch.size() >= this.batchSize) {
            ret = true;
        }
        return ret;
    }

    public List<Tuple> getTuples() {
        return this.batch;
    }

    public void resetBatch() {
        this.batch = new ArrayList<Tuple>();
    }

    public int currBatchSize() {
        return this.batch.size();
    }

    @Override
    public void setTargetTaskId(int taskId) {
        this.targetTaskId = taskId;
    }

    @Override
    public int getTargetTaskId() {
        return this.targetTaskId;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    @Deprecated
    public long getCreationTimeStamp() {
        return 0L;
    }

    @Override
    @Deprecated
    public void setCreationTimeStamp(long timeStamp) {
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

