/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.tuple;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.GeneralTopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.MessageId;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.IndifferentAccessMap;
import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentArrayMap;
import clojure.lang.Seqable;
import clojure.lang.Symbol;
import java.util.List;

public class TupleImpl
extends IndifferentAccessMap
implements Seqable,
Indexed,
IMeta,
Tuple {
    private List<Object> values;
    private int taskId;
    private String streamId;
    private GeneralTopologyContext context;
    private MessageId id;
    private IPersistentMap _meta = null;
    Long _processSampleStartTime = null;
    Long _executeSampleStartTime = null;
    long _outAckVal = 0L;

    public TupleImpl(GeneralTopologyContext context, List<Object> values, int taskId, String streamId, MessageId id) {
        this.values = values;
        this.taskId = taskId;
        this.streamId = streamId;
        this.id = id;
        this.context = context;
        String componentId = context.getComponentId(taskId);
        Fields schema = context.getComponentOutputFields(componentId, streamId);
        if (values.size() != schema.size()) {
            throw new IllegalArgumentException("Tuple created with wrong number of fields. Expected " + schema.size() + " fields but got " + values.size() + " fields");
        }
    }

    public TupleImpl(GeneralTopologyContext context, List<Object> values, int taskId, String streamId) {
        this(context, values, taskId, streamId, MessageId.makeUnanchored());
    }

    public void setProcessSampleStartTime(long ms) {
        this._processSampleStartTime = ms;
    }

    public Long getProcessSampleStartTime() {
        return this._processSampleStartTime;
    }

    public void setExecuteSampleStartTime(long ms) {
        this._executeSampleStartTime = ms;
    }

    public Long getExecuteSampleStartTime() {
        return this._executeSampleStartTime;
    }

    public void updateAckVal(long val) {
        this._outAckVal ^= val;
    }

    public long getAckVal() {
        return this._outAckVal;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int fieldIndex(String field) {
        return this.getFields().fieldIndex(field);
    }

    @Override
    public boolean contains(String field) {
        return this.getFields().contains(field);
    }

    @Override
    public Object getValue(int i) {
        return this.values.get(i);
    }

    @Override
    public String getString(int i) {
        return (String)this.values.get(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.values.get(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.values.get(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.values.get(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.values.get(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.values.get(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.values.get(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.values.get(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.values.get(i);
    }

    @Override
    public Object getValueByField(String field) {
        return this.values.get(this.fieldIndex(field));
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.values.get(this.fieldIndex(field));
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.values.get(this.fieldIndex(field));
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Fields getFields() {
        return this.context.getComponentOutputFields(this.getSourceComponent(), this.getSourceStreamId());
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.getFields().select(selector, this.values);
    }

    @Override
    public GlobalStreamId getSourceGlobalStreamid() {
        return new GlobalStreamId(this.getSourceComponent(), this.streamId);
    }

    @Override
    public String getSourceComponent() {
        return this.context.getComponentId(this.taskId);
    }

    @Override
    public int getSourceTask() {
        return this.taskId;
    }

    @Override
    public String getSourceStreamId() {
        return this.streamId;
    }

    @Override
    public MessageId getMessageId() {
        return this.id;
    }

    public String toString() {
        return "source: " + this.getSourceComponent() + ":" + this.taskId + ", stream: " + this.streamId + ", id: " + this.id.toString() + ", " + this.values.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private final Keyword makeKeyword(String name) {
        return Keyword.intern((Symbol)Symbol.create((String)name));
    }

    @Override
    public Object valAt(Object o) {
        try {
            if (o instanceof Keyword) {
                return this.getValueByField(((Keyword)o).getName());
            }
            if (o instanceof String) {
                return this.getValueByField((String)o);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ISeq seq() {
        if (this.values.size() > 0) {
            return new Seq(this.getFields().toList(), this.values, 0);
        }
        return null;
    }

    public Object nth(int i) {
        if (i < this.values.size()) {
            return this.values.get(i);
        }
        return null;
    }

    public Object nth(int i, Object notfound) {
        Object ret = this.nth(i);
        if (ret == null) {
            ret = notfound;
        }
        return ret;
    }

    @Override
    public int count() {
        return this.values.size();
    }

    public IPersistentMap meta() {
        if (this._meta == null) {
            this._meta = new PersistentArrayMap(new Object[]{this.makeKeyword("stream"), this.getSourceStreamId(), this.makeKeyword("component"), this.getSourceComponent(), this.makeKeyword("task"), this.getSourceTask()});
        }
        return this._meta;
    }

    private PersistentArrayMap toMap() {
        Object[] array = new Object[this.values.size() * 2];
        List<String> fields = this.getFields().toList();
        for (int i = 0; i < this.values.size(); ++i) {
            array[i * 2] = fields.get(i);
            array[i * 2 + 1] = this.values.get(i);
        }
        return new PersistentArrayMap(array);
    }

    @Override
    public IPersistentMap getMap() {
        if (this._map == null) {
            this.setMap((IPersistentMap)this.toMap());
        }
        return this._map;
    }

    static class Seq
    extends ASeq
    implements Counted {
        final List<String> fields;
        final List<Object> values;
        final int i;

        Seq(List<String> fields, List<Object> values, int i) {
            this.fields = fields;
            this.values = values;
            assert (i >= 0);
            this.i = i;
        }

        public Seq(IPersistentMap meta, List<String> fields, List<Object> values, int i) {
            super(meta);
            this.fields = fields;
            this.values = values;
            assert (i >= 0);
            this.i = i;
        }

        public Object first() {
            return new MapEntry((Object)this.fields.get(this.i), this.values.get(this.i));
        }

        public ISeq next() {
            if (this.i + 1 < this.fields.size()) {
                return new Seq(this.fields, this.values, this.i + 1);
            }
            return null;
        }

        public int count() {
            assert (this.fields.size() - this.i >= 0) : "index out of bounds";
            return this.fields.size() - this.i;
        }

        public Obj withMeta(IPersistentMap meta) {
            return new Seq(meta, this.fields, this.values, this.i);
        }
    }
}

