/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.metric.api.IStatefulObject;
import backtype.storm.utils.DisruptorQueueImpl;
import backtype.storm.utils.DisruptorWrapBlockingQueue;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;

public abstract class DisruptorQueue
implements IStatefulObject {
    private static boolean CAPACITY_LIMITED = false;

    public static void setUseSleep(boolean useSleep) {
        DisruptorQueueImpl.setUseSleep(useSleep);
    }

    public static void setLimited(boolean limited) {
        CAPACITY_LIMITED = limited;
    }

    public static DisruptorQueue mkInstance(String queueName, ProducerType producerType, int bufferSize, WaitStrategy wait) {
        if (CAPACITY_LIMITED) {
            return new DisruptorQueueImpl(queueName, producerType, bufferSize, wait);
        }
        return new DisruptorWrapBlockingQueue(queueName, producerType, bufferSize, wait);
    }

    public abstract String getName();

    public abstract void haltWithInterrupt();

    public abstract Object poll();

    public abstract Object take();

    public abstract void consumeBatch(EventHandler<Object> var1);

    public abstract void consumeBatchWhenAvailable(EventHandler<Object> var1);

    public abstract void publish(Object var1);

    public abstract void publish(Object var1, boolean var2) throws InsufficientCapacityException;

    public abstract void clear();

    public abstract long population();

    public abstract long capacity();

    public abstract long writePos();

    public abstract long readPos();

    public abstract float pctFull();
}

