/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.utils.Utils;
import backtype.storm.utils.VersionedStore;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalState {
    public static final Logger LOG = LoggerFactory.getLogger(LocalState.class);
    private VersionedStore _vs;

    public LocalState(String backingDir) throws IOException {
        this._vs = new VersionedStore(backingDir);
    }

    public synchronized Map<Object, Object> snapshot() throws IOException {
        int attempts = 0;
        while (true) {
            try {
                return this.deserializeLatestVersion();
            }
            catch (IOException e) {
                if (++attempts < 10) continue;
                throw e;
            }
            break;
        }
    }

    private Map<Object, Object> deserializeLatestVersion() throws IOException {
        String latestPath = this._vs.mostRecentVersionPath();
        Long latestVersion = this._vs.mostRecentVersion();
        Map<Object, Object> result2 = new HashMap<Object, Object>();
        while (latestPath != null) {
            byte[] serialized = FileUtils.readFileToByteArray((File)new File(latestPath));
            if (serialized.length == 0) {
                LOG.warn("LocalState file '{}' contained no data, skip this state", (Object)latestPath);
                latestPath = this._vs.mostRecentVersionPath(latestVersion - 1L);
                latestVersion = this._vs.mostRecentVersion(latestVersion - 1L);
                continue;
            }
            result2 = (Map)Utils.javaDeserialize(serialized);
            break;
        }
        return result2;
    }

    public Object get(Object key) throws IOException {
        return this.snapshot().get(key);
    }

    public synchronized void put(Object key, Object val) throws IOException {
        this.put(key, val, true);
    }

    public synchronized void put(Object key, Object val, boolean cleanup) throws IOException {
        Map<Object, Object> curr = this.snapshot();
        curr.put(key, val);
        this.persist(curr, cleanup);
    }

    public synchronized void remove(Object key) throws IOException {
        this.remove(key, true);
    }

    public synchronized void remove(Object key, boolean cleanup) throws IOException {
        Map<Object, Object> curr = this.snapshot();
        curr.remove(key);
        this.persist(curr, cleanup);
    }

    public synchronized void cleanup(int keepVersions) throws IOException {
        this._vs.cleanup(keepVersions);
    }

    private void persist(Map<Object, Object> val, boolean cleanup) throws IOException {
        byte[] toWrite = Utils.serialize(val);
        String newPath = this._vs.createVersion();
        FileUtils.writeByteArrayToFile((File)new File(newPath), (byte[])toWrite);
        this._vs.succeedVersion(newPath);
        if (cleanup) {
            this._vs.cleanup(4);
        }
    }
}

