/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadResourceManager<T> {
    ResourceFactory<T> _factory;
    ConcurrentLinkedQueue<T> _resources = new ConcurrentLinkedQueue();

    public ThreadResourceManager(ResourceFactory<T> factory) {
        this._factory = factory;
    }

    public T acquire() {
        T ret = this._resources.poll();
        if (ret == null) {
            ret = this._factory.makeResource();
        }
        return ret;
    }

    public void release(T resource) {
        this._resources.add(resource);
    }

    public static interface ResourceFactory<X> {
        public X makeResource();
    }
}

