/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Time {
    public static Logger LOG = LoggerFactory.getLogger(Time.class);
    private static AtomicBoolean simulating = new AtomicBoolean(false);
    private static volatile Map<Thread, AtomicLong> threadSleepTimes;
    private static final Object sleepTimesLock;
    private static AtomicLong simulatedCurrTimeMs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSimulating() {
        Object object = sleepTimesLock;
        synchronized (object) {
            simulating.set(true);
            simulatedCurrTimeMs = new AtomicLong(0L);
            threadSleepTimes = new ConcurrentHashMap<Thread, AtomicLong>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSimulating() {
        Object object = sleepTimesLock;
        synchronized (object) {
            simulating.set(false);
            threadSleepTimes = null;
        }
    }

    public static boolean isSimulating() {
        return simulating.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleepUntil(long targetTimeMs) throws InterruptedException {
        if (simulating.get()) {
            Object object;
            try {
                object = sleepTimesLock;
                synchronized (object) {
                    threadSleepTimes.put(Thread.currentThread(), new AtomicLong(targetTimeMs));
                }
                while (simulatedCurrTimeMs.get() < targetTimeMs) {
                    Thread.sleep(10L);
                }
            }
            finally {
                object = sleepTimesLock;
                synchronized (object) {
                    if (simulating.get()) {
                        threadSleepTimes.remove(Thread.currentThread());
                    }
                }
            }
        }
        long sleepTime = targetTimeMs - Time.currentTimeMillis();
        if (sleepTime > 0L) {
            Thread.sleep(sleepTime);
        }
    }

    public static void sleep(long ms) throws InterruptedException {
        Time.sleepUntil(Time.currentTimeMillis() + ms);
    }

    public static long currentTimeMillis() {
        if (simulating.get()) {
            return simulatedCurrTimeMs.get();
        }
        return System.currentTimeMillis();
    }

    public static int currentTimeSecs() {
        return (int)(Time.currentTimeMillis() / 1000L);
    }

    public static void advanceTime(long ms) {
        if (!simulating.get()) {
            throw new IllegalStateException("Cannot simulate time unless in simulation mode");
        }
        simulatedCurrTimeMs.set(simulatedCurrTimeMs.get() + ms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isThreadWaiting(Thread t) {
        AtomicLong time;
        if (!simulating.get()) {
            throw new IllegalStateException("Must be in simulation mode");
        }
        Object object = sleepTimesLock;
        synchronized (object) {
            time = threadSleepTimes.get(t);
        }
        return !t.isAlive() || time != null && Time.currentTimeMillis() < time.longValue();
    }

    static {
        sleepTimesLock = new Object();
    }
}

