/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.messaging.IConnection;
import backtype.storm.messaging.TaskMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TransferDrainer {
    private HashMap<String, ArrayList<ArrayList<TaskMessage>>> bundles = new HashMap();

    public void add(HashMap<String, ArrayList<TaskMessage>> workerTupleSetMap) {
        for (String key : workerTupleSetMap.keySet()) {
            ArrayList<TaskMessage> tupleSet;
            ArrayList<ArrayList<TaskMessage>> bundle = this.bundles.get(key);
            if (null == bundle) {
                bundle = new ArrayList();
                this.bundles.put(key, bundle);
            }
            if (null == (tupleSet = workerTupleSetMap.get(key)) || tupleSet.size() <= 0) continue;
            bundle.add(tupleSet);
        }
    }

    public void send(HashMap<String, IConnection> connections) {
        for (String hostPort : this.bundles.keySet()) {
            IConnection connection = connections.get(hostPort);
            if (null == connection) continue;
            ArrayList<ArrayList<TaskMessage>> bundle = this.bundles.get(hostPort);
            for (ArrayList<TaskMessage> list2 : bundle) {
                connection.send(list2);
            }
        }
    }

    private Iterator<TaskMessage> getBundleIterator(final ArrayList<ArrayList<TaskMessage>> bundle) {
        if (null == bundle) {
            return null;
        }
        return new Iterator<TaskMessage>(){
            private int offset = 0;
            private int size = 0;
            private int bundleOffset;
            private Iterator<TaskMessage> iter;
            {
                for (ArrayList list2 : bundle) {
                    this.size += list2.size();
                }
                this.bundleOffset = 0;
                this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.offset < this.size;
            }

            @Override
            public TaskMessage next() {
                TaskMessage msg = null;
                if (this.iter.hasNext()) {
                    msg = this.iter.next();
                } else {
                    ++this.bundleOffset;
                    this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
                    msg = this.iter.next();
                }
                if (null != msg) {
                    ++this.offset;
                }
                return msg;
            }

            @Override
            public void remove() {
                throw new RuntimeException("not supported");
            }
        };
    }

    public void clear() {
        this.bundles.clear();
    }
}

