/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.StormTopology;
import backtype.storm.serialization.DefaultSerializationDelegate;
import backtype.storm.serialization.SerializationDelegate;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.StormBoundedExponentialBackoffRetry;
import backtype.storm.utils.Time;
import backtype.storm.utils.WorkerClassLoader;
import backtype.storm.utils.ZookeeperAuthInfo;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.RT;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.LoadConf;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.thrift.TException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_STREAM_ID = "default";
    private static SerializationDelegate serializationDelegate;

    public static Object newInstance(String klass) {
        try {
            Class<?> c = Class.forName(klass);
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(String klass, Object ... params) {
        try {
            Class<?> c = Class.forName(klass);
            Constructor<?>[] constructors = c.getConstructors();
            boolean found = false;
            Constructor<?> con = null;
            for (Constructor<?> cons : constructors) {
                if (cons.getParameterTypes().length != params.length) continue;
                con = cons;
                break;
            }
            if (con == null) {
                throw new RuntimeException("Cound not found the corresponding constructor, params=" + params.toString());
            }
            if (con.getParameterTypes().length == 0) {
                return c.newInstance();
            }
            return con.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize(Object obj) {
        return Utils.javaSerialize(obj);
    }

    public static <T> T deserialize(byte[] serialized, Class<T> clazz) {
        return (T)Utils.javaDeserialize(serialized);
    }

    public static byte[] javaSerialize(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object maybe_deserialize(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            return Utils.javaDeserializeWithCL(data, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object javaDeserializeWithCL(byte[] serialized, URLClassLoader loader) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            Object ret = null;
            if (loader != null) {
                ClassLoaderObjectInputStream cis = new ClassLoaderObjectInputStream((ClassLoader)loader, (InputStream)bis);
                ret = cis.readObject();
                cis.close();
            } else {
                ObjectInputStream ois = new ObjectInputStream(bis);
                ret = ois.readObject();
                ois.close();
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object javaDeserialize(byte[] serialized) {
        return Utils.javaDeserializeWithCL(serialized, WorkerClassLoader.getInstance());
    }

    public static <T> T javaDeserialize(byte[] serialized, Class<T> clazz) {
        return (T)Utils.javaDeserializeWithCL(serialized, WorkerClassLoader.getInstance());
    }

    public static String to_json(Object m) {
        return JSONValue.toJSONString((Object)m);
    }

    public static Object from_json(String json) {
        if (json == null) {
            return null;
        }
        return JSONValue.parse((String)json);
    }

    public static String toPrettyJsonString(Object obj) {
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        String ret = gson2.toJson(obj);
        return ret;
    }

    public static byte[] gzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            out.write(data);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] gunzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            GZIPInputStream in = new GZIPInputStream(bis);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
            in.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String join(Iterable<T> coll, String sep) {
        Iterator<T> it = coll.iterator();
        String ret = "";
        while (it.hasNext()) {
            ret = ret + it.next();
            if (!it.hasNext()) continue;
            ret = ret + sep;
        }
        return ret;
    }

    public static void sleep(long millis) {
        try {
            Time.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map findAndReadConfigFile(String name) {
        return LoadConf.findAndReadYaml(name, true, false);
    }

    public static Map readDefaultConfig() {
        return LoadConf.findAndReadYaml("defaults.yaml", true, false);
    }

    public static Map readCommandLineOpts() {
        String batchOptions;
        String excludeJars;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getProperty("storm.options");
        if (commandOptions != null) {
            String[] configs;
            for (String config : configs = commandOptions.split(",")) {
                String[] options = (config = URLDecoder.decode(config)).split("=", 2);
                if (options.length != 2) continue;
                Object val = JSONValue.parse((String)options[1]);
                if (val == null) {
                    val = options[1];
                }
                ret.put(options[0], val);
            }
        }
        if ((excludeJars = System.getProperty("exclude.jars")) != null) {
            ret.put("exclude.jars", excludeJars);
        }
        if (!StringUtils.isBlank((String)(batchOptions = System.getProperty(ConfigExtension.TASK_BATCH_TUPLE)))) {
            boolean isBatched = JStormUtils.parseBoolean(batchOptions, true);
            ConfigExtension.setTaskBatchTuple(ret, isBatched);
            System.out.println(ConfigExtension.TASK_BATCH_TUPLE + " is " + batchOptions);
        }
        return ret;
    }

    public static void replaceLocalDir(Map<Object, Object> conf) {
        String stormHome = System.getProperty("jstorm.home");
        boolean isEmpty = StringUtils.isBlank((String)stormHome);
        HashMap<Object, String> replaceMap = new HashMap<Object, String>();
        for (Map.Entry<Object, Object> entry : conf.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String) || StringUtils.isBlank((String)((String)value))) continue;
            String str = (String)value;
            str = isEmpty ? str.replace("%JSTORM_HOME%", ".") : str.replace("%JSTORM_HOME%", stormHome);
            replaceMap.put(key, str);
        }
        conf.putAll(replaceMap);
    }

    public static Map loadDefinedConf(String confFile) {
        HashMap ret;
        File file = new File(confFile);
        if (!file.exists()) {
            return LoadConf.findAndReadYaml(confFile, true, false);
        }
        Yaml yaml = new Yaml();
        try {
            ret = (HashMap)yaml.load((Reader)new FileReader(file));
        }
        catch (FileNotFoundException e) {
            ret = null;
        }
        if (ret == null) {
            ret = new HashMap();
        }
        return new HashMap(ret);
    }

    public static Map readStormConfig() {
        Map ret = Utils.readDefaultConfig();
        String confFile = System.getProperty("storm.conf.file");
        Map storm = StringUtils.isBlank((String)confFile) ? LoadConf.findAndReadYaml("storm.yaml", false, false) : Utils.loadDefinedConf(confFile);
        ret.putAll(storm);
        ret.putAll(Utils.readCommandLineOpts());
        Utils.replaceLocalDir(ret);
        return ret;
    }

    private static Object normalizeConf(Object conf) {
        if (conf == null) {
            return new HashMap();
        }
        if (conf instanceof Map) {
            HashMap confMap = new HashMap((Map)conf);
            for (Object key : confMap.keySet()) {
                Object val = confMap.get(key);
                confMap.put(key, Utils.normalizeConf(val));
            }
            return confMap;
        }
        if (conf instanceof List) {
            ArrayList<Object> confList = new ArrayList<Object>((List)conf);
            for (int i = 0; i < confList.size(); ++i) {
                Object val = confList.get(i);
                confList.set(i, Utils.normalizeConf(val));
            }
            return confList;
        }
        if (conf instanceof Integer) {
            return ((Integer)conf).longValue();
        }
        if (conf instanceof Float) {
            return ((Float)conf).doubleValue();
        }
        return conf;
    }

    public static boolean isValidConf(Map<String, Object> stormConf) {
        return Utils.normalizeConf(stormConf).equals(Utils.normalizeConf(Utils.from_json(Utils.to_json(stormConf))));
    }

    public static Object getSetComponentObject(ComponentObject obj, URLClassLoader loader) {
        if (obj.getSetField() == ComponentObject._Fields.SERIALIZED_JAVA) {
            return Utils.javaDeserializeWithCL(obj.get_serialized_java(), loader);
        }
        if (obj.getSetField() == ComponentObject._Fields.JAVA_OBJECT) {
            return obj.get_java_object();
        }
        return obj.get_shell();
    }

    public static <S, T> T get(Map<S, T> m, S key, T def) {
        T ret = m.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static List<Object> tuple(Object ... values) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(v);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFromMaster(Map conf, String file, String localFile) throws IOException, TException {
        Channel out = null;
        NimbusClient client = null;
        try {
            ByteBuffer chunk;
            int written;
            client = NimbusClient.getConfiguredClient(conf, 10000);
            String id = client.getClient().beginFileDownload(file);
            out = Channels.newChannel(new FileOutputStream(localFile));
            while ((written = out.write(chunk = client.getClient().downloadChunk(id))) != 0) {
            }
            client.getClient().finishFileDownload(id);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (client != null) {
                client.close();
            }
        }
    }

    public static IFn loadClojureFn(String namespace, String name) {
        try {
            Compiler.eval((Object)RT.readString((String)("(require '" + namespace + ")")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (IFn)RT.var((String)namespace, (String)name).deref();
    }

    public static boolean isSystemId(String id) {
        return id.startsWith("__");
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> map) {
        HashMap<V, K> ret = new HashMap<V, K>();
        for (K key : map.keySet()) {
            ret.put(map.get(key), key);
        }
        return ret;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String id) {
        if (topology.get_spouts().containsKey(id)) {
            return topology.get_spouts().get(id).get_common();
        }
        if (topology.get_bolts().containsKey(id)) {
            return topology.get_bolts().get(id).get_common();
        }
        if (topology.get_state_spouts().containsKey(id)) {
            return topology.get_state_spouts().get(id).get_common();
        }
        throw new IllegalArgumentException("Could not find component with id " + id);
    }

    public static Integer getInt(Object o) {
        Integer result2 = Utils.getInt(o, null);
        if (null == result2) {
            throw new IllegalArgumentException("Don't know how to convert null to int");
        }
        return result2;
    }

    public static Integer getInt(Object o, Integer defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " to int");
    }

    public static long secureRandomLong() {
        return UUID.randomUUID().getLeastSignificantBits();
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, String root) {
        return Utils.newCurator(conf, servers, port, root, null);
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        ArrayList<String> serverPorts = new ArrayList<String>();
        for (String zkServer : servers) {
            serverPorts.add(zkServer + ":" + Utils.getInt(port));
        }
        String zkStr = StringUtils.join(serverPorts, (String)",") + root;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        Utils.setupBuilder(builder, zkStr, conf, auth);
        return builder.build();
    }

    protected static void setupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map conf, ZookeeperAuthInfo auth) {
        builder.connectString(zkStr).connectionTimeoutMs(Utils.getInt(conf.get("storm.zookeeper.connection.timeout")).intValue()).sessionTimeoutMs(Utils.getInt(conf.get("storm.zookeeper.session.timeout")).intValue()).retryPolicy((RetryPolicy)new StormBoundedExponentialBackoffRetry(Utils.getInt(conf.get("storm.zookeeper.retry.interval")), Utils.getInt(conf.get("storm.zookeeper.retry.intervalceiling.millis")), Utils.getInt(conf.get("storm.zookeeper.retry.times"))));
        if (auth != null && auth.scheme != null && auth.payload != null) {
            builder = builder.authorization(auth.scheme, auth.payload);
        }
    }

    public static CuratorFramework newCurator(Map conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        return Utils.newCurator(conf, servers, port, "", auth);
    }

    public static CuratorFramework newCuratorStarted(Map conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth) {
        CuratorFramework ret = Utils.newCurator(conf, servers, port, root, auth);
        ret.start();
        return ret;
    }

    public static CuratorFramework newCuratorStarted(Map conf, List<String> servers, Object port, ZookeeperAuthInfo auth) {
        CuratorFramework ret = Utils.newCurator(conf, servers, port, auth);
        ret.start();
        return ret;
    }

    public static TreeMap<Integer, Integer> integerDivided(int sum, int numPieces) {
        int base = sum / numPieces;
        int numInc = sum % numPieces;
        int numBases = numPieces - numInc;
        TreeMap<Integer, Integer> ret = new TreeMap<Integer, Integer>();
        ret.put(base, numBases);
        if (numInc != 0) {
            ret.put(base + 1, numInc);
        }
        return ret;
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static void readAndLogStream(String prefix, InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = r.readLine()) != null) {
                LOG.info("{}:{}", (Object)prefix, (Object)line);
            }
        }
        catch (IOException e) {
            LOG.warn("Error whiel trying to log stream", (Throwable)e);
        }
    }

    public static boolean exceptionCauseIsInstanceOf(Class klass, Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!klass.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZkAuthenticationConfiguredStormServer(Map conf) {
        return null != System.getProperty("java.security.auth.login.config") || conf != null && conf.get("storm.zookeeper.auth.scheme") != null && !((String)conf.get("storm.zookeeper.auth.scheme")).isEmpty();
    }

    public static boolean isZkAuthenticationConfiguredTopology(Map conf) {
        return conf != null && conf.get("storm.zookeeper.topology.auth.scheme") != null && !((String)conf.get("storm.zookeeper.topology.auth.scheme")).isEmpty();
    }

    public static List<ACL> getWorkerACL(Map conf) {
        if (!Utils.isZkAuthenticationConfiguredTopology(conf)) {
            return null;
        }
        String stormZKUser = (String)conf.get("storm.zookeeper.superACL");
        if (stormZKUser == null) {
            throw new IllegalArgumentException("Authentication is enabled but storm.zookeeper.superACL is not set");
        }
        String[] split = stormZKUser.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("storm.zookeeper.superACL does not appear to be in the form scheme:acl, i.e. sasl:storm-user");
        }
        ArrayList<ACL> ret = new ArrayList<ACL>(ZooDefs.Ids.CREATOR_ALL_ACL);
        ret.add(new ACL(31, new Id(split[0], split[1])));
        return ret;
    }

    public static String threadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    private static SerializationDelegate getSerializationDelegate(Map stormConf) {
        SerializationDelegate delegate;
        String delegateClassName = (String)stormConf.get("storm.meta.serialization.delegate");
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            delegate = (SerializationDelegate)delegateClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        catch (InstantiationException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        delegate.prepare(stormConf);
        return delegate;
    }

    public static void handleUncaughtException(Throwable t) {
        if (t != null && t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error..." + Thread.currentThread().getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(-1);
            } else {
                throw (Error)t;
            }
        }
    }

    public static List<String> tokenize_path(String path) {
        String[] toks = path.split("/");
        ArrayList<String> rtn = new ArrayList<String>();
        for (String str : toks) {
            if (str.isEmpty()) continue;
            rtn.add(str);
        }
        return rtn;
    }

    public static String toks_to_path(List<String> toks) {
        StringBuffer buff = new StringBuffer();
        buff.append("/");
        int size = toks.size();
        for (int i = 0; i < size; ++i) {
            buff.append(toks.get(i));
            if (i >= size - 1) continue;
            buff.append("/");
        }
        return buff.toString();
    }

    public static String normalize_path(String path) {
        String rtn = Utils.toks_to_path(Utils.tokenize_path(path));
        return rtn;
    }

    public static String printStack() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nCurrent call stack:\n");
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackElements.length; ++i) {
            sb.append("\t").append(stackElements[i]).append("\n");
        }
        return sb.toString();
    }

    private static Map loadProperty(String prop) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Properties properties = new Properties();
        try {
            FileInputStream stream = new FileInputStream(prop);
            properties.load(stream);
            if (properties.size() == 0) {
                System.out.println("WARN: Config file is empty");
                return null;
            }
            ret.putAll(properties);
        }
        catch (FileNotFoundException e) {
            System.out.println("No such file " + prop);
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1.getMessage());
        }
        return ret;
    }

    private static Map loadYaml(String confPath) {
        Map ret = new HashMap();
        Yaml yaml = new Yaml();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(confPath);
            ret = (Map)yaml.load((InputStream)stream);
            if (ret == null || ret.isEmpty()) {
                System.out.println("WARN: Config file is empty");
                Map map = null;
                return map;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("No such file " + confPath);
            throw new RuntimeException("No config file");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("Failed to read config file");
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static Map loadConf(String arg) {
        Map ret = null;
        ret = arg.endsWith("yaml") ? Utils.loadYaml(arg) : Utils.loadProperty(arg);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        String ret = "";
        InputStream input = null;
        try {
            input = Utils.class.getClassLoader().getResourceAsStream("version");
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            String s = in.readLine();
            ret = s.trim();
        }
        catch (Exception e) {
            LOG.warn("Failed to get version", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close the reader of RELEASE", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public static void writeIntToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset++] = (byte)(value & 0xFF);
        bytes[offset++] = (byte)((value & 0xFF00) >> 8);
        bytes[offset++] = (byte)((value & 0xFF0000) >> 16);
        bytes[offset] = (byte)((value & 0xFF000000) >> 24);
    }

    public static int readIntFromByteArray(byte[] bytes, int offset) {
        int ret = 0;
        ret |= bytes[offset++] & 0xFF;
        ret |= bytes[offset++] << 8 & 0xFF00;
        ret |= bytes[offset++] << 16 & 0xFF0000;
        return ret |= bytes[offset] << 24 & 0xFF000000;
    }

    static {
        Map conf = Utils.readStormConfig();
        serializationDelegate = Utils.getSerializationDelegate(conf);
    }
}

