/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.utils.Utils;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerClassLoader
extends URLClassLoader {
    public static Logger LOG = LoggerFactory.getLogger(WorkerClassLoader.class);
    private ClassLoader defaultClassLoader;
    private ClassLoader JDKClassLoader;
    private boolean isDebug;
    protected static WorkerClassLoader instance;
    protected static boolean enable;
    protected static Map<Thread, ClassLoader> threadContextCache;

    protected WorkerClassLoader(URL[] urls, ClassLoader defaultClassLoader, ClassLoader JDKClassLoader, boolean isDebug) {
        super(urls, JDKClassLoader);
        this.defaultClassLoader = defaultClassLoader;
        this.JDKClassLoader = JDKClassLoader;
        this.isDebug = isDebug;
    }

    protected boolean isLogByDefault(String name) {
        return name.startsWith("org.apache.log4j") || name.startsWith("org.slf4j");
    }

    protected boolean isLoadByDefault(String name) {
        return name.startsWith("backtype.storm") || name.startsWith("com.alibaba.jstorm") || this.isLogByDefault(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result2;
        block17: {
            Class<?> clazz;
            block20: {
                block18: {
                    block15: {
                        Class<?> clazz2;
                        block19: {
                            block16: {
                                result2 = null;
                                result2 = this.findLoadedClass(name);
                                if (result2 == null) break block15;
                                clazz2 = result2;
                                if (result2 == null) break block16;
                                ClassLoader resultClassLoader = result2.getClassLoader();
                                LOG.info("Successfully load class " + name + " by " + resultClassLoader + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
                                break block19;
                            }
                            LOG.warn("Failed to load class " + name + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
                        }
                        if (this.isDebug) {
                            LOG.info(Utils.printStack());
                        }
                        return clazz2;
                    }
                    result2 = this.JDKClassLoader.loadClass(name);
                    if (result2 == null) break block17;
                    clazz = result2;
                    if (result2 == null) break block18;
                    ClassLoader resultClassLoader = result2.getClassLoader();
                    LOG.info("Successfully load class " + name + " by " + resultClassLoader + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
                    break block20;
                }
                LOG.warn("Failed to load class " + name + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
            }
            if (this.isDebug) {
                LOG.info(Utils.printStack());
            }
            return clazz;
        }
        try {
            block21: {
                break block21;
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (!this.isLoadByDefault(name) && (result2 = this.findClass(name)) != null) {
                    Class<?> clazz = result2;
                    return clazz;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class<?> clazz = result2 = this.defaultClassLoader.loadClass(name);
            return clazz;
        }
        finally {
            if (result2 != null) {
                ClassLoader resultClassLoader = result2.getClassLoader();
                LOG.info("Successfully load class " + name + " by " + resultClassLoader + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
            } else {
                LOG.warn("Failed to load class " + name + ",threadContextLoader:" + Thread.currentThread().getContextClassLoader());
            }
            if (this.isDebug) {
                LOG.info(Utils.printStack());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkerClassLoader mkInstance(URL[] urls, ClassLoader DefaultClassLoader, ClassLoader JDKClassLoader, boolean enable, boolean isDebug) {
        WorkerClassLoader.enable = enable;
        if (!enable) {
            LOG.info("Don't enable UserDefine ClassLoader");
            return null;
        }
        Class<WorkerClassLoader> clazz = WorkerClassLoader.class;
        synchronized (WorkerClassLoader.class) {
            if (instance == null) {
                instance = new WorkerClassLoader(urls, DefaultClassLoader, JDKClassLoader, isDebug);
                threadContextCache = new ConcurrentHashMap<Thread, ClassLoader>();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            LOG.info("Successfully create classloader " + WorkerClassLoader.mk_list(urls));
            return instance;
        }
    }

    public static WorkerClassLoader getInstance() {
        return instance;
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void switchThreadContext() {
        if (!enable) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        threadContextCache.put(thread, oldClassLoader);
        thread.setContextClassLoader(instance);
    }

    public static void restoreThreadContext() {
        if (!enable) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = threadContextCache.get(thread);
        if (oldClassLoader != null) {
            thread.setContextClassLoader(oldClassLoader);
        } else {
            LOG.info("No context classloader of " + thread.getName());
        }
    }

    private static <V> List<V> mk_list(V ... args) {
        ArrayList<V> rtn = new ArrayList<V>();
        for (V o : args) {
            rtn.add(o);
        }
        return rtn;
    }
}

