/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils.disruptor;

import backtype.storm.utils.disruptor.AbstractSequencerExt;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public class SingleProducerSequencer
extends AbstractSequencerExt {
    private final Padding pad = new Padding();

    public SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
    }

    public boolean hasAvailableCapacity(int requiredCapacity) {
        long nextValue = this.pad.nextValue;
        long wrapPoint = nextValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.pad.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            this.pad.cachedValue = minSequence = Util.getMinimumSequence((Sequence[])this.gatingSequences, (long)nextValue);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    public long next() {
        return this.next(1);
    }

    public long next(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        long nextValue = this.pad.nextValue;
        long nextSequence = nextValue + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.pad.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence((Sequence[])this.gatingSequences, (long)nextValue))) {
                if (AbstractSequencerExt.isWaitSleep()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                LockSupport.parkNanos(1L);
            }
            this.pad.cachedValue = minSequence;
        }
        this.pad.nextValue = nextSequence;
        return nextSequence;
    }

    public long tryNext() throws InsufficientCapacityException {
        return this.tryNext(1);
    }

    public long tryNext(int n) throws InsufficientCapacityException {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (!this.hasAvailableCapacity(n)) {
            throw InsufficientCapacityException.INSTANCE;
        }
        long nextSequence = this.pad.nextValue += (long)n;
        return nextSequence;
    }

    public long remainingCapacity() {
        long nextValue = this.pad.nextValue;
        long consumed = Util.getMinimumSequence((Sequence[])this.gatingSequences, (long)nextValue);
        long produced = nextValue;
        return (long)this.getBufferSize() - (produced - consumed);
    }

    public void claim(long sequence) {
        this.pad.nextValue = sequence;
    }

    public void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    public void publish(long lo, long hi) {
        this.publish(hi);
    }

    public boolean isAvailable(long sequence) {
        return sequence <= this.cursor.get();
    }

    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        return availableSequence;
    }

    private static class Padding {
        public long nextValue = -1L;
        public long cachedValue = -1L;
        public long p2;
        public long p3;
        public long p4;
        public long p5;
        public long p6;
        public long p7;

        private Padding() {
        }
    }
}

