/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.batch;

import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import com.alibaba.jstorm.batch.IBatchSpout;
import com.alibaba.jstorm.batch.ICommitter;
import com.alibaba.jstorm.batch.IPostCommit;
import com.alibaba.jstorm.batch.IPrepareCommit;
import com.alibaba.jstorm.batch.impl.BatchSpoutTrigger;
import com.alibaba.jstorm.batch.impl.CoordinatedBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTopologyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(BatchTopologyBuilder.class);
    private TopologyBuilder topologyBuilder = new TopologyBuilder();
    private SpoutDeclarer spoutDeclarer = this.topologyBuilder.setSpout("spout_trigger", new BatchSpoutTrigger(), (Number)1);

    public BatchTopologyBuilder(String topologyName) {
    }

    public BoltDeclarer setSpout(String id, IBatchSpout spout, int paralel) {
        BoltDeclarer boltDeclarer = this.setBolt(id, spout, paralel);
        boltDeclarer.allGrouping("spout_trigger", "batch/compute-stream");
        return boltDeclarer;
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt, int paralel) {
        CoordinatedBolt coordinatedBolt = new CoordinatedBolt(bolt);
        BoltDeclarer boltDeclarer = this.topologyBuilder.setBolt(id, coordinatedBolt, (Number)paralel);
        if (bolt instanceof IPrepareCommit) {
            boltDeclarer.allGrouping("spout_trigger", "batch/parepare-stream");
        }
        if (bolt instanceof ICommitter) {
            boltDeclarer.allGrouping("spout_trigger", "batch/commit-stream");
            boltDeclarer.allGrouping("spout_trigger", "batch/revert-stream");
        }
        if (bolt instanceof IPostCommit) {
            boltDeclarer.allGrouping("spout_trigger", "batch/post-stream");
        }
        return boltDeclarer;
    }

    public TopologyBuilder getTopologyBuilder() {
        return this.topologyBuilder;
    }
}

