/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.batch.util;

import com.alibaba.jstorm.cluster.ClusterState;
import com.alibaba.jstorm.cluster.DistributedClusterState;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCommon {
    private static final Logger LOG = LoggerFactory.getLogger(BatchCommon.class);
    private static ClusterState zkClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterState getZkClient(Map conf) throws Exception {
        Class<BatchCommon> clazz = BatchCommon.class;
        synchronized (BatchCommon.class) {
            if (zkClient != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zkClient;
            }
            List zkServers = null;
            if (conf.get("transactional.zookeeper.servers") != null) {
                zkServers = (List)conf.get("transactional.zookeeper.servers");
            } else if (conf.get("storm.zookeeper.servers") != null) {
                zkServers = (List)conf.get("storm.zookeeper.servers");
            } else {
                throw new RuntimeException("No setting zk");
            }
            int port = 2181;
            if (conf.get("transactional.zookeeper.port") != null) {
                port = JStormUtils.parseInt(conf.get("transactional.zookeeper.port"), 2181);
            } else if (conf.get("storm.zookeeper.port") != null) {
                port = JStormUtils.parseInt(conf.get("storm.zookeeper.port"), 2181);
            }
            String root = "batch";
            if (conf.get("transactional.zookeeper.root") != null) {
                root = (String)conf.get("transactional.zookeeper.root");
            }
            root = root + "/" + conf.get("topology.name");
            HashMap<Object, Object> tmpConf = new HashMap<Object, Object>();
            tmpConf.putAll(conf);
            tmpConf.put("storm.zookeeper.servers", zkServers);
            tmpConf.put("storm.zookeeper.root", root);
            zkClient = new DistributedClusterState(tmpConf);
            LOG.info("Successfully connect ZK");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zkClient;
        }
    }
}

