/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cache;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cache.JStormCache;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBCache
implements JStormCache {
    private static final long serialVersionUID = 705938812240167583L;
    private static Logger LOG = LoggerFactory.getLogger(RocksDBCache.class);
    public static final String ROCKSDB_ROOT_DIR = "rocksdb.root.dir";
    public static final String ROCKSDB_RESET = "rocksdb.reset";
    protected RocksDB db;
    protected String rootDir;

    public void initDir(Map<Object, Object> conf) {
        File file;
        String confDir = (String)conf.get(ROCKSDB_ROOT_DIR);
        if (StringUtils.isBlank((String)confDir)) {
            throw new RuntimeException("Doesn't set rootDir of rocksDB");
        }
        boolean clean = (Boolean)conf.get(ROCKSDB_RESET);
        LOG.info("RocksDB reset is " + clean);
        if (clean) {
            try {
                PathUtils.rmr(confDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to cleanup rooDir of rocksDB " + confDir);
            }
        }
        if (!(file = new File(confDir)).exists()) {
            try {
                PathUtils.local_mkdirs(confDir);
                file = new File(confDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to mkdir rooDir of rocksDB " + confDir);
            }
        }
        this.rootDir = file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDb(List<Integer> list2) throws Exception {
        LOG.info("Begin to init rocksDB of {}", (Object)this.rootDir);
        Options dbOptions = null;
        try {
            dbOptions = new Options().setCreateMissingColumnFamilies(true).setCreateIfMissing(true);
            ArrayList columnFamilyHandleList = new ArrayList();
            this.db = RocksDB.open((Options)dbOptions, (String)this.rootDir);
            LOG.info("Successfully init rocksDB of {}", (Object)this.rootDir);
        }
        finally {
            if (dbOptions != null) {
                dbOptions.dispose();
            }
        }
    }

    @Override
    public void init(Map<Object, Object> conf) throws Exception {
        this.initDir(conf);
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        if (conf.get("cache.timeout.list") != null) {
            for (Integer obj : ConfigExtension.getCacheTimeoutList(conf)) {
                Integer timeoutSecond = JStormUtils.parseInt(obj);
                if (timeoutSecond == null || timeoutSecond <= 0) continue;
                list2.add(timeoutSecond);
            }
        }
        boolean isSuccess = false;
        for (int i = 0; i < 3; ++i) {
            try {
                this.initDb(list2);
                isSuccess = true;
                break;
            }
            catch (Exception e) {
                LOG.warn("Failed to init rocksDB " + this.rootDir, (Throwable)e);
                try {
                    PathUtils.rmr(this.rootDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!isSuccess) {
            throw new RuntimeException("Failed to init rocksDB " + this.rootDir);
        }
    }

    @Override
    public void cleanup() {
        LOG.info("Begin to close rocketDb of {}", (Object)this.rootDir);
        if (this.db != null) {
            this.db.close();
        }
        LOG.info("Successfully closed rocketDb of {}", (Object)this.rootDir);
    }

    @Override
    public Object get(String key) {
        try {
            byte[] data = this.db.get(key.getBytes());
            if (data != null) {
                try {
                    return Utils.javaDeserialize(data);
                }
                catch (Exception e) {
                    LOG.error("Failed to deserialize obj of " + key);
                    this.db.remove(key.getBytes());
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void getBatch(Map<String, Object> map) {
        ArrayList<byte[]> lookupKeys = new ArrayList<byte[]>();
        for (String key : map.keySet()) {
            lookupKeys.add(key.getBytes());
        }
        try {
            Map results = this.db.multiGet(lookupKeys);
            if (results == null || results.size() == 0) {
                return;
            }
            for (Map.Entry resultEntry : results.entrySet()) {
                Object value;
                byte[] keyByte = (byte[])resultEntry.getKey();
                byte[] valueByte = (byte[])resultEntry.getValue();
                if (keyByte == null || valueByte == null) continue;
                try {
                    value = Utils.javaDeserialize(valueByte);
                }
                catch (Exception e) {
                    LOG.error("Failed to deserialize obj of " + new String(keyByte));
                    this.db.remove(keyByte);
                    continue;
                }
                map.put(new String(keyByte), value);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to query " + map.keySet() + ", in window: ");
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.db.remove(key.getBytes());
        }
        catch (Exception e) {
            LOG.error("Failed to remove " + key);
        }
    }

    @Override
    public void removeBatch(Collection<String> keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Object value, int timeoutSecond) {
        this.put(key, value);
    }

    @Override
    public void put(String key, Object value) {
        byte[] data = Utils.javaSerialize(value);
        try {
            this.db.put(key.getBytes(), data);
        }
        catch (Exception e) {
            LOG.error("Failed put into cache, " + key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBatch(Map<String, Object> map) {
        WriteOptions writeOpts = null;
        WriteBatch writeBatch = null;
        HashSet<byte[]> putKeys = new HashSet<byte[]>();
        try {
            writeOpts = new WriteOptions();
            writeBatch = new WriteBatch();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                byte[] data = Utils.javaSerialize(value);
                if (StringUtils.isBlank((String)key) || data == null || data.length == 0) continue;
                byte[] keyByte = key.getBytes();
                writeBatch.put(keyByte, data);
                putKeys.add(keyByte);
            }
            this.db.write(writeOpts, writeBatch);
        }
        catch (Exception e) {
            LOG.error("Failed to putBatch into DB, " + map.keySet(), (Throwable)e);
        }
        finally {
            if (writeOpts != null) {
                writeOpts.dispose();
            }
            if (writeBatch != null) {
                writeBatch.dispose();
            }
        }
    }

    @Override
    public void putBatch(Map<String, Object> map, int timeoutSeconds) {
        this.putBatch(map);
    }

    static {
        RocksDB.loadLibrary();
    }
}

