/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cache;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cache.JStormCache;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.TtlDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksTTLDBCache
implements JStormCache {
    private static final long serialVersionUID = 705938812240167583L;
    private static Logger LOG = LoggerFactory.getLogger(RocksTTLDBCache.class);
    public static final String ROCKSDB_ROOT_DIR = "rocksdb.root.dir";
    public static final String ROCKSDB_RESET = "rocksdb.reset";
    protected TtlDB ttlDB;
    protected String rootDir;
    protected TreeMap<Integer, ColumnFamilyHandle> windowHandlers = new TreeMap();

    public void initDir(Map<Object, Object> conf) {
        File file;
        String confDir = (String)conf.get(ROCKSDB_ROOT_DIR);
        if (StringUtils.isBlank((String)confDir)) {
            throw new RuntimeException("Doesn't set rootDir of rocksDB");
        }
        boolean clean = ConfigExtension.getNimbusCacheReset(conf);
        LOG.info("RocksDB reset is " + clean);
        if (clean) {
            try {
                PathUtils.rmr(confDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to cleanup rooDir of rocksDB " + confDir);
            }
        }
        if (!(file = new File(confDir)).exists()) {
            try {
                PathUtils.local_mkdirs(confDir);
                file = new File(confDir);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to mkdir rooDir of rocksDB " + confDir);
            }
        }
        this.rootDir = file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDb(List<Integer> list2) throws Exception {
        LOG.info("Begin to init rocksDB of {}", (Object)this.rootDir);
        DBOptions dbOptions = null;
        ArrayList<ColumnFamilyDescriptor> columnFamilyNames = new ArrayList<ColumnFamilyDescriptor>();
        columnFamilyNames.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY));
        for (Integer timeout : list2) {
            columnFamilyNames.add(new ColumnFamilyDescriptor(String.valueOf(timeout).getBytes()));
        }
        ArrayList<Integer> ttlValues = new ArrayList<Integer>();
        ttlValues.add(0);
        ttlValues.addAll(list2);
        try {
            dbOptions = new DBOptions().setCreateMissingColumnFamilies(true).setCreateIfMissing(true);
            ArrayList columnFamilyHandleList = new ArrayList();
            this.ttlDB = TtlDB.open((DBOptions)dbOptions, (String)this.rootDir, columnFamilyNames, columnFamilyHandleList, ttlValues, (boolean)false);
            for (int i = 0; i < ttlValues.size(); ++i) {
                this.windowHandlers.put((Integer)ttlValues.get(i), (ColumnFamilyHandle)columnFamilyHandleList.get(i));
            }
            LOG.info("Successfully init rocksDB of {}", (Object)this.rootDir);
        }
        finally {
            if (dbOptions != null) {
                dbOptions.dispose();
            }
        }
    }

    @Override
    public void init(Map<Object, Object> conf) throws Exception {
        this.initDir(conf);
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        if (conf.get("cache.timeout.list") != null) {
            for (Integer obj : ConfigExtension.getCacheTimeoutList(conf)) {
                Integer timeoutSecond = JStormUtils.parseInt(obj);
                if (timeoutSecond == null || timeoutSecond <= 0) continue;
                list2.add(timeoutSecond);
            }
        }
        boolean isSuccess = false;
        for (int i = 0; i < 3; ++i) {
            try {
                this.initDb(list2);
                isSuccess = true;
                break;
            }
            catch (Exception e) {
                LOG.warn("Failed to init rocksDB " + this.rootDir, (Throwable)e);
                try {
                    PathUtils.rmr(this.rootDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!isSuccess) {
            throw new RuntimeException("Failed to init rocksDB " + this.rootDir);
        }
    }

    @Override
    public void cleanup() {
        LOG.info("Begin to close rocketDb of {}", (Object)this.rootDir);
        for (ColumnFamilyHandle columnFamilyHandle : this.windowHandlers.values()) {
            columnFamilyHandle.dispose();
        }
        if (this.ttlDB != null) {
            this.ttlDB.close();
        }
        LOG.info("Successfully closed rocketDb of {}", (Object)this.rootDir);
    }

    @Override
    public Object get(String key) {
        for (Map.Entry<Integer, ColumnFamilyHandle> entry : this.windowHandlers.entrySet()) {
            try {
                byte[] data = this.ttlDB.get(entry.getValue(), key.getBytes());
                if (data == null) continue;
                try {
                    return Utils.javaDeserialize(data);
                }
                catch (Exception e) {
                    LOG.error("Failed to deserialize obj of " + key);
                    this.ttlDB.remove(entry.getValue(), key.getBytes());
                    return null;
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public void getBatch(Map<String, Object> map) {
        ArrayList<byte[]> lookupKeys = new ArrayList<byte[]>();
        for (String string : map.keySet()) {
            lookupKeys.add(string.getBytes());
        }
        for (Map.Entry entry : this.windowHandlers.entrySet()) {
            ArrayList cfHandlers = new ArrayList();
            for (String key : map.keySet()) {
                cfHandlers.add(entry.getValue());
            }
            try {
                Map results = this.ttlDB.multiGet(cfHandlers, lookupKeys);
                if (results == null || results.size() == 0) continue;
                for (Map.Entry resultEntry : results.entrySet()) {
                    byte[] keyByte = (byte[])resultEntry.getKey();
                    byte[] valueByte = (byte[])resultEntry.getValue();
                    if (keyByte == null || valueByte == null) continue;
                    Object value = null;
                    try {
                        value = Utils.javaDeserialize(valueByte);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to deserialize obj of " + new String(keyByte));
                        this.ttlDB.remove((ColumnFamilyHandle)entry.getValue(), keyByte);
                        continue;
                    }
                    map.put(new String(keyByte), value);
                }
                return;
            }
            catch (Exception e) {
                LOG.error("Failed to query " + map.keySet() + ", in window: " + entry.getKey());
            }
        }
    }

    @Override
    public void remove(String key) {
        for (Map.Entry<Integer, ColumnFamilyHandle> entry : this.windowHandlers.entrySet()) {
            try {
                this.ttlDB.remove(entry.getValue(), key.getBytes());
            }
            catch (Exception e) {
                LOG.error("Failed to remove " + key);
            }
        }
    }

    @Override
    public void removeBatch(Collection<String> keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    protected void put(String key, Object value, Map.Entry<Integer, ColumnFamilyHandle> entry) {
        byte[] data = Utils.javaSerialize(value);
        try {
            this.ttlDB.put(entry.getValue(), key.getBytes(), data);
        }
        catch (Exception e) {
            LOG.error("Failed put into cache, " + key, (Throwable)e);
            return;
        }
        for (Map.Entry<Integer, ColumnFamilyHandle> removeEntry : this.windowHandlers.entrySet()) {
            if (removeEntry.getKey().equals(entry.getKey())) continue;
            try {
                this.ttlDB.remove(removeEntry.getValue(), key.getBytes());
            }
            catch (Exception e) {
                LOG.warn("Failed to remove other " + key);
            }
        }
    }

    protected Map.Entry<Integer, ColumnFamilyHandle> getHandler(int timeoutSecond) {
        Object cfHandler = null;
        Map.Entry<Integer, ColumnFamilyHandle> ceilingEntry = this.windowHandlers.ceilingEntry(timeoutSecond);
        if (ceilingEntry != null) {
            return ceilingEntry;
        }
        return this.windowHandlers.firstEntry();
    }

    @Override
    public void put(String key, Object value, int timeoutSecond) {
        this.put(key, value, this.getHandler(timeoutSecond));
    }

    @Override
    public void put(String key, Object value) {
        this.put(key, value, this.windowHandlers.firstEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putBatch(Map<String, Object> map, Map.Entry<Integer, ColumnFamilyHandle> putEntry) {
        WriteOptions writeOpts = null;
        WriteBatch writeBatch = null;
        HashSet<byte[]> putKeys = new HashSet<byte[]>();
        try {
            writeOpts = new WriteOptions();
            writeBatch = new WriteBatch();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                byte[] data = Utils.javaSerialize(value);
                if (StringUtils.isBlank((String)key) || data == null || data.length == 0) continue;
                byte[] keyByte = key.getBytes();
                writeBatch.put(putEntry.getValue(), keyByte, data);
                putKeys.add(keyByte);
            }
            this.ttlDB.write(writeOpts, writeBatch);
        }
        catch (Exception e) {
            LOG.error("Failed to putBatch into DB, " + map.keySet(), (Throwable)e);
        }
        finally {
            if (writeOpts != null) {
                writeOpts.dispose();
            }
            if (writeBatch != null) {
                writeBatch.dispose();
            }
        }
        for (Map.Entry<Object, Object> entry : this.windowHandlers.entrySet()) {
            if (((Integer)entry.getKey()).equals(putEntry.getKey())) continue;
            for (byte[] keyByte : putKeys) {
                try {
                    this.ttlDB.remove((ColumnFamilyHandle)entry.getValue(), keyByte);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove other's " + new String(keyByte));
                }
            }
        }
    }

    @Override
    public void putBatch(Map<String, Object> map) {
        this.putBatch(map, this.windowHandlers.firstEntry());
    }

    @Override
    public void putBatch(Map<String, Object> map, int timeoutSeconds) {
        this.putBatch(map, this.getHandler(timeoutSeconds));
    }

    static {
        RocksDB.loadLibrary();
    }
}

