/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cache;

import com.alibaba.jstorm.cache.JStormCache;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeCacheMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutMemCache
implements JStormCache {
    private static final long serialVersionUID = 705938812240167583L;
    private static Logger LOG = LoggerFactory.getLogger(TimeoutMemCache.class);
    protected int defaultTimeout;
    protected final TreeMap<Integer, TimeCacheMap<String, Object>> cacheWindows = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCacheWindow(int timeoutSecond) {
        TimeoutMemCache timeoutMemCache = this;
        synchronized (timeoutMemCache) {
            if (this.cacheWindows.get(timeoutSecond) == null) {
                TimeCacheMap cacheWindow = new TimeCacheMap(timeoutSecond);
                this.cacheWindows.put(timeoutSecond, cacheWindow);
                LOG.info("Successfully register CacheWindow: " + timeoutSecond);
            } else {
                LOG.info("CacheWindow: " + timeoutSecond + " has been registered");
            }
        }
    }

    @Override
    public void init(Map<Object, Object> conf) {
        this.defaultTimeout = ConfigExtension.getDefaultCacheTimeout(conf);
        this.registerCacheWindow(this.defaultTimeout);
        List<Integer> list2 = ConfigExtension.getCacheTimeoutList(conf);
        if (list2 != null) {
            for (Integer obj : list2) {
                Integer timeoutSecond = JStormUtils.parseInt(obj);
                if (timeoutSecond == null) continue;
                this.registerCacheWindow(timeoutSecond);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Object get(String key) {
        for (TimeCacheMap<String, Object> cacheWindow : this.cacheWindows.values()) {
            Object ret = cacheWindow.get(key);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public void getBatch(Map<String, Object> map) {
        for (String key : map.keySet()) {
            Object obj = this.get(key);
            map.put(key, obj);
        }
    }

    @Override
    public void remove(String key) {
        for (TimeCacheMap<String, Object> cacheWindow : this.cacheWindows.values()) {
            Object ret = cacheWindow.remove(key);
            if (ret == null) continue;
            return;
        }
    }

    @Override
    public void removeBatch(Collection<String> keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Object value, int timeoutSecond) {
        Map.Entry<Integer, TimeCacheMap<String, Object>> ceilingEntry = this.cacheWindows.ceilingEntry(timeoutSecond);
        if (ceilingEntry == null) {
            this.put(key, value);
        } else {
            this.remove(key);
            ceilingEntry.getValue().put(key, value);
        }
    }

    @Override
    public void put(String key, Object value) {
        this.remove(key);
        TimeCacheMap<String, Object> bestWindow = this.cacheWindows.get(this.defaultTimeout);
        bestWindow.put(key, value);
    }

    @Override
    public void putBatch(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putBatch(Map<String, Object> map, int timeoutSeconds) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), timeoutSeconds);
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }
}

