/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.callback;

import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLoopRunnable
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger(AsyncLoopRunnable.class);
    private static AtomicBoolean shutdown = new AtomicBoolean(false);
    private RunnableCallback fn;
    private RunnableCallback killfn;
    private long lastTime = System.currentTimeMillis();

    public static AtomicBoolean getShutdown() {
        return shutdown;
    }

    public AsyncLoopRunnable(RunnableCallback fn, RunnableCallback killfn) {
        this.fn = fn;
        this.killfn = killfn;
    }

    private boolean needQuit(Object rtn) {
        if (rtn != null) {
            long sleepTime = Long.parseLong(String.valueOf(rtn));
            if (sleepTime < 0L) {
                return true;
            }
            if (sleepTime > 0L) {
                long now = System.currentTimeMillis();
                long cost = now - this.lastTime;
                long sleepMs = sleepTime * 1000L - cost;
                if (sleepMs > 0L) {
                    JStormUtils.sleepMs(sleepMs);
                    this.lastTime = System.currentTimeMillis();
                } else {
                    this.lastTime = now;
                }
            }
        }
        return false;
    }

    private void shutdown() {
        this.fn.postRun();
        this.fn.shutdown();
        LOG.info("Successfully shutdown");
    }

    @Override
    public void run() {
        if (this.fn == null) {
            LOG.error("fn==null");
            throw new RuntimeException("AsyncLoopRunnable no core function ");
        }
        this.fn.preRun();
        try {
            while (!shutdown.get()) {
                Exception e = null;
                this.fn.run();
                if (shutdown.get()) {
                    this.shutdown();
                    return;
                }
                e = this.fn.error();
                if (e != null) {
                    throw e;
                }
                Object rtn = this.fn.getResult();
                if (!this.needQuit(rtn)) continue;
                this.shutdown();
                return;
            }
        }
        catch (Throwable e) {
            if (shutdown.get()) {
                this.shutdown();
                return;
            }
            LOG.error("Async loop died!!!" + e.getMessage(), e);
            this.killfn.execute(e);
        }
    }
}

