/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.callback;

import backtype.storm.utils.Time;
import com.alibaba.jstorm.callback.AsyncLoopDefaultKill;
import com.alibaba.jstorm.callback.AsyncLoopRunnable;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.SmartThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncLoopThread
implements SmartThread {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncLoopThread.class);
    private Thread thread;
    private RunnableCallback afn;

    public AsyncLoopThread(RunnableCallback afn) {
        this.init(afn, false, 5, true);
    }

    public AsyncLoopThread(RunnableCallback afn, boolean daemon, int priority, boolean start) {
        this.init(afn, daemon, priority, start);
    }

    public AsyncLoopThread(RunnableCallback afn, boolean daemon, RunnableCallback kill_fn, int priority, boolean start) {
        this.init(afn, daemon, kill_fn, priority, start);
    }

    public void init(RunnableCallback afn, boolean daemon, int priority, boolean start) {
        AsyncLoopDefaultKill kill_fn = new AsyncLoopDefaultKill();
        this.init(afn, daemon, kill_fn, priority, start);
    }

    private void init(RunnableCallback afn, boolean daemon, RunnableCallback kill_fn, int priority, boolean start) {
        if (kill_fn == null) {
            kill_fn = new AsyncLoopDefaultKill();
        }
        AsyncLoopRunnable runable = new AsyncLoopRunnable(afn, kill_fn);
        this.thread = new Thread(runable);
        String threadName = afn.getThreadName();
        if (threadName == null) {
            threadName = afn.getClass().getSimpleName();
        }
        this.thread.setName(threadName);
        this.thread.setDaemon(daemon);
        this.thread.setPriority(priority);
        this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("UncaughtException", e);
                JStormUtils.halt_process(1, "UncaughtException");
            }
        });
        this.afn = afn;
        if (start) {
            this.thread.start();
        }
    }

    @Override
    public void start() {
        this.thread.start();
    }

    @Override
    public void join() throws InterruptedException {
        this.thread.join();
    }

    public void join(int times) throws InterruptedException {
        this.thread.join(times);
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public Boolean isSleeping() {
        return Time.isThreadWaiting(this.thread);
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void cleanup() {
        this.afn.shutdown();
    }
}

