/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.callback.impl;

import com.alibaba.jstorm.callback.BaseCallback;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.cluster.StormStatus;
import com.alibaba.jstorm.daemon.nimbus.NimbusData;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import com.alibaba.jstorm.schedule.DelayEventRunnable;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayStatusTransitionCallback
extends BaseCallback {
    private static Logger LOG = LoggerFactory.getLogger(DelayStatusTransitionCallback.class);
    public static final int DEFAULT_DELAY_SECONDS = 30;
    protected NimbusData data;
    protected String topologyid;
    protected StormStatus oldStatus;
    protected StatusType newType;
    protected StatusType nextAction;

    public DelayStatusTransitionCallback(NimbusData data, String topologyid, StormStatus oldStatus, StatusType newType, StatusType nextAction) {
        this.data = data;
        this.topologyid = topologyid;
        this.oldStatus = oldStatus;
        this.newType = newType;
        this.nextAction = nextAction;
    }

    public int getDelaySeconds(Object[] args) {
        if (this.oldStatus != null && this.oldStatus.getDelaySecs() > 0) {
            return this.oldStatus.getDelaySecs();
        }
        Integer delaySecs = 30;
        if (args == null || args.length == 0 || args[0] == null) {
            Map map = null;
            try {
                map = StormConfig.read_nimbus_topology_conf(this.data.getConf(), this.topologyid);
                delaySecs = JStormUtils.parseInt(map.get("topology.message.timeout.secs"), 30);
            }
            catch (Exception e) {
                LOG.info("Failed to get topology configuration " + this.topologyid);
            }
        } else {
            delaySecs = JStormUtils.parseInt(args[0]);
        }
        if (delaySecs == null || delaySecs < 0) {
            delaySecs = 30;
        }
        return delaySecs;
    }

    @Override
    public <T> Object execute(T ... args) {
        int delaySecs = this.getDelaySeconds(args);
        LOG.info("Delaying event " + (Object)((Object)this.newType) + " for " + delaySecs + " secs for " + this.topologyid);
        this.data.getScheduExec().schedule(new DelayEventRunnable(this.data, this.topologyid, this.nextAction, args), (long)delaySecs, TimeUnit.SECONDS);
        return new StormStatus(delaySecs, this.newType);
    }
}

