/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.callback.impl;

import com.alibaba.jstorm.callback.BaseCallback;
import com.alibaba.jstorm.cluster.StormBase;
import com.alibaba.jstorm.daemon.nimbus.NimbusData;
import com.alibaba.jstorm.daemon.nimbus.NimbusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveTransitionCallback
extends BaseCallback {
    private static Logger LOG = LoggerFactory.getLogger(RemoveTransitionCallback.class);
    private NimbusData data;
    private String topologyid;

    public RemoveTransitionCallback(NimbusData data, String topologyid) {
        this.data = data;
        this.topologyid = topologyid;
    }

    @Override
    public <T> Object execute(T ... args) {
        LOG.info("Begin to remove topology: " + this.topologyid);
        try {
            StormBase stormBase = this.data.getStormClusterState().storm_base(this.topologyid, null);
            if (stormBase == null) {
                LOG.info("Topology " + this.topologyid + " has been removed ");
                return null;
            }
            this.data.getStormClusterState().remove_storm(this.topologyid);
            this.data.getTasksHeartbeat().remove(this.topologyid);
            NimbusUtils.removeTopologyTaskTimeout(this.data, this.topologyid);
            LOG.info("Successfully removed ZK items topology: " + this.topologyid);
        }
        catch (Exception e) {
            LOG.warn("Failed to remove StormBase " + this.topologyid + " from ZK", (Throwable)e);
        }
        return null;
    }
}

