/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.callback.impl;

import com.alibaba.jstorm.callback.BaseCallback;
import com.alibaba.jstorm.callback.impl.DelayStatusTransitionCallback;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.cluster.StormStatus;
import com.alibaba.jstorm.daemon.nimbus.NimbusData;
import com.alibaba.jstorm.schedule.Assignment;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTopologyTransitionCallback
extends BaseCallback {
    private static Logger LOG = LoggerFactory.getLogger(DelayStatusTransitionCallback.class);
    public static final int DEFAULT_DELAY_SECONDS = 30;
    private NimbusData data;
    private String topologyId;
    private StormStatus currentStatus;

    public UpdateTopologyTransitionCallback(NimbusData data, String topologyId, StormStatus currentStatus) {
        this.data = data;
        this.topologyId = topologyId;
        this.currentStatus = currentStatus;
    }

    @Override
    public <T> Object execute(T ... args) {
        StormClusterState clusterState = this.data.getStormClusterState();
        try {
            Map userConf = (Map)args[0];
            Map topoConf = StormConfig.read_nimbus_topology_conf(this.data.getConf(), this.topologyId);
            topoConf.putAll(userConf);
            StormConfig.write_nimbus_topology_conf(this.data.getConf(), this.topologyId, topoConf);
            Assignment assignment = clusterState.assignment_info(this.topologyId, null);
            assignment.setAssignmentType(Assignment.AssignmentType.UpdateTopology);
            assignment.updateTimeStamp();
            clusterState.set_assignment(this.topologyId, assignment);
            LOG.info("Successfully update topology information to ZK for " + this.topologyId);
        }
        catch (Exception e) {
            LOG.error("Failed to update topology.", (Throwable)e);
        }
        return this.currentStatus;
    }
}

