/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.client;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.WorkerAssignment;
import com.alibaba.jstorm.utils.JStormUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConfigExtension {
    protected static final String TOPOLOGY_DEBUG_RECV_TUPLE = "topology.debug.recv.tuple";
    private static final String TOPOLOGY_DEBUG_SAMPLE_RATE = "topology.debug.sample.rate";
    private static final String TOPOLOGY_ENABLE_METRIC_DEBUG = "topology.enable.metric.debug";
    private static final String TOPOLOGY_DEBUG_METRIC_NAMES = "topology.debug.metric.names";
    private static final String TOPOLOGY_ENABLE_METRICS = "topology.enable.metrics";
    public static final String TOPOLOGY_ENABLE_STREAM_METRICS = "topology.enable.stream.metrics";
    private static final String TOPOLOGY_ENABLED_METRIC_NAMES = "topology.enabled.metric.names";
    private static final String TOPOLOGY_DISABLED_METRIC_NAMES = "topology.disabled.metric.names";
    private static final Integer DEFAULT_DEAMON_HTTPSERVER_PORT = 7621;
    protected static final String SUPERVISOR_DEAMON_HTTPSERVER_PORT = "supervisor.deamon.logview.port";
    protected static final String NIMBUS_DEAMON_HTTPSERVER_PORT = "nimbus.deamon.logview.port";
    protected static final String WORKER_GC_CHILDOPTS = "worker.gc.childopts";
    protected static final String WOREKER_REDIRECT_OUTPUT = "worker.redirect.output";
    protected static final String WOREKER_REDIRECT_OUTPUT_FILE = "worker.redirect.output.file";
    protected static final String OUTPUT_WOEKER_DUMP = "output.worker.dump";
    protected static final String SPOUT_DELAY_RUN = "spout.delay.run";
    public static final int DEFAULT_ZMQ_MAX_QUEUE_MSG = 1000;
    protected static final String MEM_SLOTS_PER_TASK = "memory.slots.per.task";
    protected static final String CPU_SLOTS_PER_TASK = "cpu.slots.per.task";
    protected static final String STORM_MACHINE_RESOURCE_RESERVE_MEM = " storm.machine.resource.reserve.mem";
    protected static final String STORM_MACHINE_RESOURCE_RESERVE_CPU_PERCENT = "storm.machine.resource.reserve.cpu.percent";
    protected static final String TASK_ON_DIFFERENT_NODE = "task.on.differ.node";
    protected static final String SUPERVISOR_ENABLE_CGROUP = "supervisor.enable.cgroup";
    protected static final String SUPERVISOR_ENABLE_CHECK = "supervisor.enable.check";
    protected static String SUPERVISOR_FREQUENCY_CHECK = "supervisor.frequency.check.secs";
    protected static final String STORM_HEALTH_CHECK_DIR = "storm.health.check.dir";
    protected static final String STORM_MACHINE_RESOURCE_PANIC_CHECK_DIR = "storm.machine.resource.panic.check.dir";
    protected static final String STORM_MACHINE_RESOURCE_ERROR_CHECK_DIR = "storm.machine.resource.error.check.dir";
    protected static final String STORM_MACHINE_RESOURCE_WARNING_CHECK_DIR = "storm.machine.resource.warning.check.dir";
    protected static final String STORM_HEALTH_CHECK_TIMEOUT_MS = "storm.health.check.timeout.ms";
    protected static final String STORM_HEALTH_CHECK_MAX_DISK_UTILIZATION_PERCENTAGE = "storm.health.check.dir.max.disk.utilization.percentage";
    protected static final String STORM_HEALTH_CHECK_MIN_DISK_FREE_SPACE_MB = "storm.health.check.min.disk.free.space.mb";
    protected static final String USE_OLD_ASSIGNMENT = "use.old.assignment";
    protected static final String SUPERVISOR_HOSTNAME = "supervisor.hostname";
    public static final Object SUPERVISOR_HOSTNAME_SCHEMA = String.class;
    protected static final String SUPERVISOR_USE_IP = "supervisor.use.ip";
    protected static final String NIMBUS_USE_IP = "nimbus.use.ip";
    protected static final String TOPOLOGY_ENABLE_CLASSLOADER = "topology.enable.classloader";
    protected static String CLASSLOADER_DEBUG = "classloader.debug";
    protected static final String CONTAINER_NIMBUS_HEARTBEAT = "container.nimbus.heartbeat";
    protected static final String CONTAINER_SUPERVISOR_HEARTBEAT = "container.supervisor.heartbeat";
    protected static final String CONTAINER_HEARTBEAT_TIMEOUT_SECONDS = "container.heartbeat.timeout.seconds";
    protected static final String CONTAINER_HEARTBEAT_FREQUENCE = "container.heartbeat.frequence";
    protected static final String JAVA_SANDBOX_ENABLE = "java.sandbox.enable";
    protected static String SPOUT_SINGLE_THREAD = "spout.single.thread";
    protected static String WORKER_STOP_WITHOUT_SUPERVISOR = "worker.stop.without.supervisor";
    protected static String CGROUP_ROOT_DIR = "supervisor.cgroup.rootdir";
    protected static String NETTY_TRANSFER_ASYNC_AND_BATCH = "storm.messaging.netty.transfer.async.batch";
    protected static final String USE_USERDEFINE_ASSIGNMENT = "use.userdefine.assignment";
    protected static String NETTY_PENDING_BUFFER_TIMEOUT = "storm.messaging.netty.pending.buffer.timeout";
    protected static final String MEMSIZE_PER_WORKER = "worker.memory.size";
    protected static final String MIN_MEMSIZE_PER_WORKER = "worker.memory.min.size";
    protected static final String CPU_SLOT_PER_WORKER = "worker.cpu.slot.num";
    protected static String TOPOLOGY_PERFORMANCE_METRICS = "topology.performance.metrics";
    protected static String NETTY_BUFFER_THRESHOLD_SIZE = "storm.messaging.netty.buffer.threshold";
    protected static String NETTY_MAX_SEND_PENDING = "storm.messaging.netty.max.pending";
    protected static String DISRUPTOR_USE_SLEEP = "disruptor.use.sleep";
    protected static String NETTY_SYNC_MODE = "storm.messaging.netty.sync.mode";
    protected static String NETTY_ASYNC_BLOCK = "storm.messaging.netty.async.block";
    protected static String ALIMONITOR_METRICS_POST = "topology.alimonitor.metrics.post";
    public static String TASK_CLEANUP_TIMEOUT_SEC = "task.cleanup.timeout.sec";
    protected static String UI_CLUSTERS = "ui.clusters";
    protected static String UI_CLUSTER_NAME = "name";
    protected static String UI_CLUSTER_ZK_ROOT = "zkRoot";
    protected static String UI_CLUSTER_ZK_SERVERS = "zkServers";
    protected static String UI_CLUSTER_ZK_PORT = "zkPort";
    protected static String SPOUT_PEND_FULL_SLEEP = "spout.pending.full.sleep";
    protected static String LOGVIEW_ENCODING = "supervisor.deamon.logview.encoding";
    protected static String UTF8 = "utf-8";
    protected static String LOG_PAGE_SIZE = "log.page.size";
    public static String MAX_MATCH_PER_LOG_SEARCH = "max.match.per.log.search";
    public static String MAX_BLOCKS_PER_LOG_SEARCH = "max.blocks.per.log.search";
    public static String CHANGE_LOG_LEVEL_CONFIG = "change.log.level.config";
    public static String CHANGE_LOG_LEVEL_TIMESTAMP = "change.log.level.timestamp";
    public static String TASK_STATUS_ACTIVE = "Active";
    public static String TASK_STATUS_INACTIVE = "Inactive";
    public static String TASK_STATUS_STARTING = "Starting";
    protected static String ALIMONITOR_TOPO_METIRC_NAME = "topology.alimonitor.topo.metrics.name";
    protected static String ALIMONITOR_TASK_METIRC_NAME = "topology.alimonitor.task.metrics.name";
    protected static String ALIMONITOR_WORKER_METIRC_NAME = "topology.alimonitor.worker.metrics.name";
    protected static String ALIMONITOR_USER_METIRC_NAME = "topology.alimonitor.user.metrics.name";
    protected static String SPOUT_PARALLELISM = "topology.spout.parallelism";
    protected static String BOLT_PARALLELISM = "topology.bolt.parallelism";
    protected static String TOPOLOGY_BUFFER_SIZE_LIMITED = "topology.buffer.size.limited";
    protected static String SUPERVISOR_SLOTS_PORTS_BASE = "supervisor.slots.ports.base";
    protected static String SUPERVISOR_SLOTS_PORT_CPU_WEIGHT = "supervisor.slots.port.cpu.weight";
    protected static String SUPERVISOR_SLOTS_PORT_MEM_WEIGHT = "supervisor.slots.port.mem.weight";
    protected static String USER_DEFINED_LOG4J_CONF = "user.defined.log4j.conf";
    protected static String USER_DEFINED_LOGBACK_CONF = "user.defined.logback.conf";
    protected static String TASK_ERROR_INFO_REPORT_INTERVAL = "topology.task.error.report.interval";
    protected static String DEFAULT_CACHE_TIMEOUT = "default.cache.timeout";
    protected static String WORKER_MERTRIC_REPORT_CHECK_FREQUENCY = "worker.metric.report.frequency.secs";
    protected static String LOCAL_WORKER_PORT = "local.worker.port";
    protected static String LOCLA_WORKER_ID = "local.worker.id";
    protected static String LOCAL_SUPERVISOR_ID = "local.supervisor.id";
    protected static String WORKER_CPU_CORE_UPPER_LIMIT = "worker.cpu.core.upper.limit";
    protected static String CLUSTER_NAME = "cluster.name";
    protected static final String NIMBUS_CACHE_CLASS = "nimbus.cache.class";
    protected static final String NIMBUS_CACHE_RESET = "nimbus.cache.reset";
    protected static final String NIMBUS_METRIC_CACHE_RESET = "nimbus.metric.cache.reset";
    public static final double DEFAULT_METRIC_SAMPLE_RATE = 0.05;
    public static final String TOPOLOGY_METRIC_SAMPLE_RATE = "topology.metric.sample.rate";
    public static final String TOPOLOGY_TIMER_UPDATE_INTERVAL = "topology.timer.update.interval";
    public static final String CACHE_TIMEOUT_LIST = "cache.timeout.list";
    public static final String METRIC_UPLOADER_CLASS = "nimbus.metric.uploader.class";
    public static final String METRIC_QUERY_CLIENT_CLASS = "nimbus.metric.query.client.class";
    protected static String TASK_MSG_BATCH_SIZE = "task.msg.batch.size";
    public static String TASK_BATCH_TUPLE = "task.batch.tuple";
    protected static String TASK_BATCH_FLUSH_INTERVAL_MS = "task.msg.batch.flush.interval.millis";
    protected static String TOPOLOGY_MAX_WORKER_NUM_FOR_NETTY_METRICS = "topology.max.worker.num.for.netty.metrics";
    protected static String UI_ONE_TABLE_PAGE_SIZE = "ui.one.table.page.size";
    protected static String MAX_PENDING_METRIC_NUM = "topology.max.pending.metric.num";
    protected static String TOPOLOGY_MASTER_SINGLE_WORKER = "topology.master.single.worker";
    public static String TOPOLOGY_BACKPRESSURE_WATER_MARK_HIGH = "topology.backpressure.water.mark.high";
    public static String TOPOLOGY_BACKPRESSURE_WATER_MARK_LOW = "topology.backpressure.water.mark.low";
    protected static String TOPOLOGY_BACKPRESSURE_CHECK_INTERVAL = "topology.backpressure.check.interval";
    protected static String TOPOLOGY_BACKPRESSURE_TRIGGER_SAMPLE_NUMBER = "topology.backpressure.trigger.sample.number";
    protected static String TOPOLOGY_BACKPRESSURE_TRIGGER_SAMPLE_RATE = "topology.backpressure.trigger.sample.rate";
    public static String TOPOLOGY_BACKPRESSURE_ENABLE = "topology.backpressure.enable";
    public static String TOPOLOGY_BACKPRESSURE_COORDINATOR_RATIO = "topology.backpressure.coordinator.trigger.ratio";
    protected static String SUPERVISOR_CHECK_WORKER_BY_SYSTEM_INFO = "supervisor.check.worker.by.system.info";
    protected static String TOPOLOGY_TASK_HEARTBEAT_SEND_NUMBER = "topology.task.heartbeat.send.number";
    protected static String PROCESS_LAUNCHER_ENABLE = "process.launcher.enable";
    protected static String PROCESS_LAUNCHER_SLEEP_SECONDS = "process.launcher.sleep.seconds";
    protected static String PROCESS_LAUNCHER_CHILDOPTS = "process.launcher.childopts";

    public static void setTopologyDebugRecvTuple(Map conf, boolean debug) {
        conf.put(TOPOLOGY_DEBUG_RECV_TUPLE, debug);
    }

    public static Boolean isTopologyDebugRecvTuple(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_DEBUG_RECV_TUPLE), false);
    }

    public static double getTopologyDebugSampleRate(Map conf) {
        double rate = JStormUtils.parseDouble(conf.get(TOPOLOGY_DEBUG_SAMPLE_RATE), 1.0);
        if (!conf.containsKey(TOPOLOGY_DEBUG_SAMPLE_RATE)) {
            conf.put(TOPOLOGY_DEBUG_SAMPLE_RATE, rate);
        }
        return rate;
    }

    public static void setTopologyDebugSampleRate(Map conf, double rate) {
        conf.put(TOPOLOGY_DEBUG_SAMPLE_RATE, rate);
    }

    public static boolean isEnableMetricDebug(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_ENABLE_METRIC_DEBUG), false);
    }

    public static String getDebugMetricNames(Map conf) {
        String metrics = (String)conf.get(TOPOLOGY_DEBUG_METRIC_NAMES);
        if (metrics == null) {
            return "";
        }
        return metrics;
    }

    public static boolean isEnableMetrics(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_ENABLE_METRICS), true);
    }

    public static boolean isEnableStreamMetrics(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_ENABLE_STREAM_METRICS), true);
    }

    public static String getEnabledMetricNames(Map conf) {
        return (String)conf.get(TOPOLOGY_ENABLED_METRIC_NAMES);
    }

    public static void setEnabledMetricNames(Map conf, String metrics) {
        conf.put(TOPOLOGY_ENABLED_METRIC_NAMES, metrics);
    }

    public static String getDisabledMetricNames(Map conf) {
        return (String)conf.get(TOPOLOGY_DISABLED_METRIC_NAMES);
    }

    public static void setDisabledMetricNames(Map conf, String metrics) {
        conf.put(TOPOLOGY_DISABLED_METRIC_NAMES, metrics);
    }

    public static Integer getSupervisorDeamonHttpserverPort(Map conf) {
        return JStormUtils.parseInt(conf.get(SUPERVISOR_DEAMON_HTTPSERVER_PORT), DEFAULT_DEAMON_HTTPSERVER_PORT + 1);
    }

    public static Integer getNimbusDeamonHttpserverPort(Map conf) {
        return JStormUtils.parseInt(conf.get(NIMBUS_DEAMON_HTTPSERVER_PORT), DEFAULT_DEAMON_HTTPSERVER_PORT);
    }

    public static void setWorkerGc(Map conf, String gc) {
        conf.put(WORKER_GC_CHILDOPTS, gc);
    }

    public static String getWorkerGc(Map conf) {
        return (String)conf.get(WORKER_GC_CHILDOPTS);
    }

    public static boolean getWorkerRedirectOutput(Map conf) {
        Object result2 = conf.get(WOREKER_REDIRECT_OUTPUT);
        if (result2 == null) {
            return false;
        }
        return (Boolean)result2;
    }

    public static void setWorkerRedirectOutputFile(Map conf, String outputPath) {
        conf.put(WOREKER_REDIRECT_OUTPUT_FILE, outputPath);
    }

    public static String getWorkerRedirectOutputFile(Map conf) {
        return (String)conf.get(WOREKER_REDIRECT_OUTPUT_FILE);
    }

    public static boolean isOutworkerDump(Map conf) {
        return JStormUtils.parseBoolean(conf.get(OUTPUT_WOEKER_DUMP), false);
    }

    public static void setSpoutDelayRunSeconds(Map conf, int delay) {
        conf.put(SPOUT_DELAY_RUN, delay);
    }

    public static int getSpoutDelayRunSeconds(Map conf) {
        return JStormUtils.parseInt(conf.get(SPOUT_DELAY_RUN), 30);
    }

    @Deprecated
    public static void setMemSlotPerTask(Map conf, int slotNum) {
        if (slotNum < 1) {
            throw new InvalidParameterException();
        }
        conf.put(MEM_SLOTS_PER_TASK, slotNum);
    }

    @Deprecated
    public static void setCpuSlotsPerTask(Map conf, int slotNum) {
        if (slotNum < 1) {
            throw new InvalidParameterException();
        }
        conf.put(CPU_SLOTS_PER_TASK, slotNum);
    }

    public static long getStormMachineReserveMem(Map conf) {
        Long reserve = JStormUtils.parseLong(conf.get(STORM_MACHINE_RESOURCE_RESERVE_MEM), 0x40000000L);
        return reserve < 0x40000000L ? 0x40000000L : reserve;
    }

    public static void setStormMachineReserveMem(Map conf, long percent) {
        conf.put(STORM_MACHINE_RESOURCE_RESERVE_MEM, percent);
    }

    public static int getStormMachineReserveCpuPercent(Map conf) {
        int percent = JStormUtils.parseInt(conf.get(STORM_MACHINE_RESOURCE_RESERVE_CPU_PERCENT), 10);
        return percent < 10 ? 10 : percent;
    }

    public static void setStormMachineReserveCpuPercent(Map conf, int percent) {
        conf.put(STORM_MACHINE_RESOURCE_RESERVE_CPU_PERCENT, percent);
    }

    public static void setTaskOnDifferentNode(Map conf, boolean isIsolate) {
        conf.put(TASK_ON_DIFFERENT_NODE, isIsolate);
    }

    public static boolean isTaskOnDifferentNode(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TASK_ON_DIFFERENT_NODE), false);
    }

    public static boolean isEnableCgroup(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SUPERVISOR_ENABLE_CGROUP), false);
    }

    public static boolean isEnableCheckSupervisor(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SUPERVISOR_ENABLE_CHECK), false);
    }

    public static int getSupervisorFrequencyCheck(Map conf) {
        return JStormUtils.parseInt(conf.get(SUPERVISOR_FREQUENCY_CHECK), 60);
    }

    public static String getStormHealthCheckDir(Map conf) {
        return (String)conf.get(STORM_HEALTH_CHECK_DIR);
    }

    public static String getStormMachineResourcePanicCheckDir(Map conf) {
        return (String)conf.get(STORM_MACHINE_RESOURCE_PANIC_CHECK_DIR);
    }

    public static String getStormMachineResourceErrorCheckDir(Map conf) {
        return (String)conf.get(STORM_MACHINE_RESOURCE_ERROR_CHECK_DIR);
    }

    public static String getStormMachineResourceWarningCheckDir(Map conf) {
        return (String)conf.get(STORM_MACHINE_RESOURCE_WARNING_CHECK_DIR);
    }

    public static long getStormHealthTimeoutMs(Map conf) {
        return JStormUtils.parseLong(conf.get(STORM_HEALTH_CHECK_TIMEOUT_MS), 5000L);
    }

    public static float getStormHealthCheckMaxDiskUtilizationPercentage(Map conf) {
        return ((Float)conf.get(STORM_HEALTH_CHECK_MAX_DISK_UTILIZATION_PERCENTAGE)).floatValue();
    }

    public static long getStormHealthCheckMinDiskFreeSpaceMb(Map conf) {
        return (Long)conf.get(STORM_HEALTH_CHECK_MIN_DISK_FREE_SPACE_MB);
    }

    public static void setUseOldAssignment(Map conf, boolean useOld) {
        conf.put(USE_OLD_ASSIGNMENT, useOld);
    }

    public static boolean isUseOldAssignment(Map conf) {
        return JStormUtils.parseBoolean(conf.get(USE_OLD_ASSIGNMENT), false);
    }

    public static String getSupervisorHost(Map conf) {
        return (String)conf.get(SUPERVISOR_HOSTNAME);
    }

    public static boolean isSupervisorUseIp(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SUPERVISOR_USE_IP), false);
    }

    public static boolean isNimbusUseIp(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NIMBUS_USE_IP), true);
    }

    public static boolean isEnableTopologyClassLoader(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_ENABLE_CLASSLOADER), false);
    }

    public static void setEnableTopologyClassLoader(Map conf, boolean enable) {
        conf.put(TOPOLOGY_ENABLE_CLASSLOADER, enable);
    }

    public static boolean isEnableClassloaderDebug(Map conf) {
        return JStormUtils.parseBoolean(conf.get(CLASSLOADER_DEBUG), false);
    }

    public static void setEnableClassloaderDebug(Map conf, boolean enable) {
        conf.put(CLASSLOADER_DEBUG, enable);
    }

    public static boolean isEnableContainerNimbus() {
        String path = System.getenv(CONTAINER_NIMBUS_HEARTBEAT);
        return !StringUtils.isBlank((String)path);
    }

    public static String getContainerNimbusHearbeat() {
        return System.getenv(CONTAINER_NIMBUS_HEARTBEAT);
    }

    public static boolean isEnableContainerSupervisor() {
        String path = System.getenv(CONTAINER_SUPERVISOR_HEARTBEAT);
        return !StringUtils.isBlank((String)path);
    }

    public static String getContainerSupervisorHearbeat() {
        return System.getenv(CONTAINER_SUPERVISOR_HEARTBEAT);
    }

    public static int getContainerHeartbeatTimeoutSeconds(Map conf) {
        return JStormUtils.parseInt(conf.get(CONTAINER_HEARTBEAT_TIMEOUT_SECONDS), 240);
    }

    public static int getContainerHeartbeatFrequence(Map conf) {
        return JStormUtils.parseInt(conf.get(CONTAINER_HEARTBEAT_FREQUENCE), 10);
    }

    public static boolean isJavaSandBoxEnable(Map conf) {
        return JStormUtils.parseBoolean(conf.get(JAVA_SANDBOX_ENABLE), false);
    }

    public static boolean isSpoutSingleThread(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SPOUT_SINGLE_THREAD), false);
    }

    public static void setSpoutSingleThread(Map conf, boolean enable) {
        conf.put(SPOUT_SINGLE_THREAD, enable);
    }

    public static boolean isWorkerStopWithoutSupervisor(Map conf) {
        return JStormUtils.parseBoolean(conf.get(WORKER_STOP_WITHOUT_SUPERVISOR), false);
    }

    public static String getCgroupRootDir(Map conf) {
        return (String)conf.get(CGROUP_ROOT_DIR);
    }

    public static boolean isNettyTransferAsyncBatch(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NETTY_TRANSFER_ASYNC_AND_BATCH), true);
    }

    public static void setUserDefineAssignment(Map conf, List<WorkerAssignment> userDefines) {
        ArrayList<String> ret = new ArrayList<String>();
        for (WorkerAssignment worker : userDefines) {
            ret.add(Utils.to_json(worker));
        }
        conf.put(USE_USERDEFINE_ASSIGNMENT, ret);
    }

    public static List<WorkerAssignment> getUserDefineAssignment(Map conf) {
        ArrayList<WorkerAssignment> ret = new ArrayList<WorkerAssignment>();
        if (conf.get(USE_USERDEFINE_ASSIGNMENT) == null) {
            return ret;
        }
        for (String worker : (List)conf.get(USE_USERDEFINE_ASSIGNMENT)) {
            ret.add(WorkerAssignment.parseFromObj(Utils.from_json(worker)));
        }
        return ret;
    }

    public static void setNettyPendingBufferTimeout(Map conf, Long timeout) {
        conf.put(NETTY_PENDING_BUFFER_TIMEOUT, timeout);
    }

    public static long getNettyPendingBufferTimeout(Map conf) {
        int messageTimeout = JStormUtils.parseInt(conf.get("topology.message.timeout.secs"), 120);
        return JStormUtils.parseLong(conf.get(NETTY_PENDING_BUFFER_TIMEOUT), messageTimeout * 1000);
    }

    public static void setMemSizePerWorker(Map conf, long memSize) {
        conf.put(MEMSIZE_PER_WORKER, memSize);
    }

    public static void setMemSizePerWorkerByKB(Map conf, long memSize) {
        long size = memSize * 1024L;
        ConfigExtension.setMemSizePerWorker(conf, size);
    }

    public static void setMemSizePerWorkerByMB(Map conf, long memSize) {
        long size = memSize * 1024L;
        ConfigExtension.setMemSizePerWorkerByKB(conf, size);
    }

    public static void setMemSizePerWorkerByGB(Map conf, long memSize) {
        long size = memSize * 1024L;
        ConfigExtension.setMemSizePerWorkerByMB(conf, size);
    }

    public static long getMemSizePerWorker(Map conf) {
        long size = JStormUtils.parseLong(conf.get(MEMSIZE_PER_WORKER), JStormUtils.SIZE_1_G * 2L);
        return size > 0L ? size : JStormUtils.SIZE_1_G * 2L;
    }

    public static void setMemMinSizePerWorker(Map conf, long memSize) {
        conf.put(MIN_MEMSIZE_PER_WORKER, memSize);
    }

    private static boolean isMemMinSizePerWorkerValid(Long size, long maxMemSize) {
        if (size == null) {
            return false;
        }
        if (size <= 0x8000000L) {
            return false;
        }
        return size <= maxMemSize;
    }

    public static long getMemMinSizePerWorker(Map conf) {
        long maxMemSize = ConfigExtension.getMemSizePerWorker(conf);
        Long size = JStormUtils.parseLong(conf.get(MIN_MEMSIZE_PER_WORKER));
        if (ConfigExtension.isMemMinSizePerWorkerValid(size, maxMemSize)) {
            return size;
        }
        return maxMemSize;
    }

    public static void setCpuSlotNumPerWorker(Map conf, int slotNum) {
        conf.put(CPU_SLOT_PER_WORKER, slotNum);
    }

    public static int getCpuSlotPerWorker(Map conf) {
        int slot = JStormUtils.parseInt(conf.get(CPU_SLOT_PER_WORKER), 1);
        return slot > 0 ? slot : 1;
    }

    public static boolean isEnablePerformanceMetrics(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_PERFORMANCE_METRICS), true);
    }

    public static void setPerformanceMetrics(Map conf, boolean isEnable) {
        conf.put(TOPOLOGY_PERFORMANCE_METRICS, isEnable);
    }

    public static long getNettyBufferThresholdSize(Map conf) {
        return JStormUtils.parseLong(conf.get(NETTY_BUFFER_THRESHOLD_SIZE), 8L * JStormUtils.SIZE_1_M);
    }

    public static void setNettyBufferThresholdSize(Map conf, long size) {
        conf.put(NETTY_BUFFER_THRESHOLD_SIZE, size);
    }

    public static void setNettyMaxSendPending(Map conf, long pending) {
        conf.put(NETTY_MAX_SEND_PENDING, pending);
    }

    public static long getNettyMaxSendPending(Map conf) {
        return JStormUtils.parseLong(conf.get(NETTY_MAX_SEND_PENDING), 16L);
    }

    public static boolean isDisruptorUseSleep(Map conf) {
        return JStormUtils.parseBoolean(conf.get(DISRUPTOR_USE_SLEEP), true);
    }

    public static void setDisruptorUseSleep(Map conf, boolean useSleep) {
        conf.put(DISRUPTOR_USE_SLEEP, useSleep);
    }

    public static boolean isTopologyContainAcker(Map conf) {
        int num = JStormUtils.parseInt(conf.get("topology.acker.executors"), 1);
        return num > 0;
    }

    public static boolean isNettySyncMode(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NETTY_SYNC_MODE), false);
    }

    public static void setNettySyncMode(Map conf, boolean sync) {
        conf.put(NETTY_SYNC_MODE, sync);
    }

    public static boolean isNettyASyncBlock(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NETTY_ASYNC_BLOCK), true);
    }

    public static void setNettyASyncBlock(Map conf, boolean block) {
        conf.put(NETTY_ASYNC_BLOCK, block);
    }

    public static boolean isAlimonitorMetricsPost(Map conf) {
        return JStormUtils.parseBoolean(conf.get(ALIMONITOR_METRICS_POST), true);
    }

    public static void setAlimonitorMetricsPost(Map conf, boolean post) {
        conf.put(ALIMONITOR_METRICS_POST, post);
    }

    public static int getTaskCleanupTimeoutSec(Map conf) {
        return JStormUtils.parseInt(conf.get(TASK_CLEANUP_TIMEOUT_SEC), 10);
    }

    public static void setTaskCleanupTimeoutSec(Map conf, int timeout) {
        conf.put(TASK_CLEANUP_TIMEOUT_SEC, timeout);
    }

    public static List<Map> getUiClusters(Map conf) {
        return (List)conf.get(UI_CLUSTERS);
    }

    public static void setUiClusters(Map conf, List<Map> uiClusters) {
        conf.put(UI_CLUSTERS, uiClusters);
    }

    public static Map getUiClusterInfo(List<Map> uiClusters, String name) {
        Map ret = null;
        for (Map cluster : uiClusters) {
            String clusterName = ConfigExtension.getUiClusterName(cluster);
            if (!clusterName.equals(name)) continue;
            ret = cluster;
            break;
        }
        return ret;
    }

    public static String getUiClusterName(Map uiCluster) {
        return (String)uiCluster.get(UI_CLUSTER_NAME);
    }

    public static String getUiClusterZkRoot(Map uiCluster) {
        return (String)uiCluster.get(UI_CLUSTER_ZK_ROOT);
    }

    public static List<String> getUiClusterZkServers(Map uiCluster) {
        return (List)uiCluster.get(UI_CLUSTER_ZK_SERVERS);
    }

    public static Integer getUiClusterZkPort(Map uiCluster) {
        return JStormUtils.parseInt(uiCluster.get(UI_CLUSTER_ZK_PORT));
    }

    public static boolean isSpoutPendFullSleep(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SPOUT_PEND_FULL_SLEEP), false);
    }

    public static void setSpoutPendFullSleep(Map conf, boolean sleep) {
        conf.put(SPOUT_PEND_FULL_SLEEP, sleep);
    }

    public static String getLogViewEncoding(Map conf) {
        String ret = (String)conf.get(LOGVIEW_ENCODING);
        if (ret == null) {
            ret = UTF8;
        }
        return ret;
    }

    public static void setLogViewEncoding(Map conf, String enc) {
        conf.put(LOGVIEW_ENCODING, enc);
    }

    public static int getLogPageSize(Map conf) {
        return JStormUtils.parseInt(conf.get(LOG_PAGE_SIZE), 65536);
    }

    public static void setLogPageSize(Map conf, int pageSize) {
        conf.put(LOG_PAGE_SIZE, pageSize);
    }

    public static int getMaxMatchPerLogSearch(Map conf) {
        return JStormUtils.parseInt(conf.get(MAX_MATCH_PER_LOG_SEARCH), 10);
    }

    public static void setMaxMatchPerLogSearch(Map conf, int maxMatch) {
        conf.put(MAX_MATCH_PER_LOG_SEARCH, maxMatch);
    }

    public static int getMaxBlocksPerLogSearch(Map conf) {
        return JStormUtils.parseInt(conf.get(MAX_BLOCKS_PER_LOG_SEARCH), 1024);
    }

    public static Map<String, String> getChangeLogLevelConfig(Map conf) {
        return (Map)conf.get(CHANGE_LOG_LEVEL_CONFIG);
    }

    public static Long getChangeLogLevelTimeStamp(Map conf) {
        return (Long)conf.get(CHANGE_LOG_LEVEL_TIMESTAMP);
    }

    public static String getAlmonTopoMetricName(Map conf) {
        return (String)conf.get(ALIMONITOR_TOPO_METIRC_NAME);
    }

    public static String getAlmonTaskMetricName(Map conf) {
        return (String)conf.get(ALIMONITOR_TASK_METIRC_NAME);
    }

    public static String getAlmonWorkerMetricName(Map conf) {
        return (String)conf.get(ALIMONITOR_WORKER_METIRC_NAME);
    }

    public static String getAlmonUserMetricName(Map conf) {
        return (String)conf.get(ALIMONITOR_USER_METIRC_NAME);
    }

    public static Integer getSpoutParallelism(Map conf, String componentName) {
        Integer ret = null;
        Map map = (Map)conf.get(SPOUT_PARALLELISM);
        if (map != null) {
            ret = JStormUtils.parseInt(map.get(componentName));
        }
        return ret;
    }

    public static Integer getBoltParallelism(Map conf, String componentName) {
        Integer ret = null;
        Map map = (Map)conf.get(BOLT_PARALLELISM);
        if (map != null) {
            ret = JStormUtils.parseInt(map.get(componentName));
        }
        return ret;
    }

    public static void setTopologyBufferSizeLimited(Map conf, boolean limited) {
        conf.put(TOPOLOGY_BUFFER_SIZE_LIMITED, limited);
    }

    public static boolean getTopologyBufferSizeLimited(Map conf) {
        boolean isSynchronized = ConfigExtension.isNettySyncMode(conf);
        if (isSynchronized) {
            return true;
        }
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_BUFFER_SIZE_LIMITED), true);
    }

    public static int getSupervisorSlotsPortsBase(Map conf) {
        return JStormUtils.parseInt(conf.get(SUPERVISOR_SLOTS_PORTS_BASE), 6800);
    }

    public static double getSupervisorSlotsPortCpuWeight(Map conf) {
        Object value = conf.get(SUPERVISOR_SLOTS_PORT_CPU_WEIGHT);
        Double ret = JStormUtils.convertToDouble(value);
        if (ret == null || ret <= 0.0) {
            return 1.2;
        }
        return ret;
    }

    public static double getSupervisorSlotsPortMemWeight(Map conf) {
        Object value = conf.get(SUPERVISOR_SLOTS_PORT_MEM_WEIGHT);
        Double ret = JStormUtils.convertToDouble(value);
        if (ret == null || ret <= 0.0) {
            return 0.7;
        }
        return ret;
    }

    public static String getUserDefinedLog4jConf(Map conf) {
        return (String)conf.get(USER_DEFINED_LOG4J_CONF);
    }

    public static void setUserDefinedLog4jConf(Map conf, String fileName) {
        conf.put(USER_DEFINED_LOG4J_CONF, fileName);
    }

    public static String getUserDefinedLogbackConf(Map conf) {
        return (String)conf.get(USER_DEFINED_LOGBACK_CONF);
    }

    public static void setUserDefinedLogbackConf(Map conf, String fileName) {
        conf.put(USER_DEFINED_LOGBACK_CONF, fileName);
    }

    public static Integer getTaskErrorReportInterval(Map conf) {
        return JStormUtils.parseInt(conf.get(TASK_ERROR_INFO_REPORT_INTERVAL), 60);
    }

    public static void setTaskErrorReportInterval(Map conf, Integer interval) {
        conf.put(TASK_ERROR_INFO_REPORT_INTERVAL, interval);
    }

    public static int getDefaultCacheTimeout(Map conf) {
        return JStormUtils.parseInt(conf.get(DEFAULT_CACHE_TIMEOUT), 60);
    }

    public static void setDefaultCacheTimeout(Map conf, int timeout) {
        conf.put(DEFAULT_CACHE_TIMEOUT, timeout);
    }

    public static int getWorkerMetricReportCheckFrequency(Map conf) {
        return JStormUtils.parseInt(conf.get(WORKER_MERTRIC_REPORT_CHECK_FREQUENCY), 60);
    }

    public static void setWorkerMetricReportFrequency(Map conf, int frequence) {
        conf.put(WORKER_MERTRIC_REPORT_CHECK_FREQUENCY, frequence);
    }

    public static int getLocalWorkerPort(Map conf) {
        return JStormUtils.parseInt(conf.get(LOCAL_WORKER_PORT));
    }

    public static void setLocalWorkerPort(Map conf, int port) {
        conf.put(LOCAL_WORKER_PORT, port);
    }

    public static String getLocalWorkerId(Map conf) {
        return (String)conf.get(LOCLA_WORKER_ID);
    }

    public static void setLocalWorkerId(Map conf, String workerId) {
        conf.put(LOCLA_WORKER_ID, workerId);
    }

    public static String getLocalSupervisorId(Map conf) {
        return (String)conf.get(LOCAL_SUPERVISOR_ID);
    }

    public static void setLocalSupervisorId(Map conf, String supervisorId) {
        conf.put(LOCAL_SUPERVISOR_ID, supervisorId);
    }

    public static Integer getWorkerCpuCoreUpperLimit(Map conf) {
        return JStormUtils.parseInt(conf.get(WORKER_CPU_CORE_UPPER_LIMIT), 1);
    }

    public static void setWorkerCpuCoreUpperLimit(Map conf, Integer cpuUpperLimit) {
        conf.put(WORKER_CPU_CORE_UPPER_LIMIT, cpuUpperLimit);
    }

    public static String getClusterName(Map conf) {
        return (String)conf.get(CLUSTER_NAME);
    }

    public static void setClusterName(Map conf, String clusterName) {
        conf.put(CLUSTER_NAME, clusterName);
    }

    public static String getNimbusCacheClass(Map conf) {
        return (String)conf.get(NIMBUS_CACHE_CLASS);
    }

    public static boolean getNimbusCacheReset(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NIMBUS_CACHE_RESET), true);
    }

    public static boolean getMetricCacheReset(Map conf) {
        return JStormUtils.parseBoolean(conf.get(NIMBUS_METRIC_CACHE_RESET), false);
    }

    public static double getMetricSampleRate(Map conf) {
        double sampleRate = JStormUtils.parseDouble(conf.get(TOPOLOGY_METRIC_SAMPLE_RATE), 0.05);
        if (!conf.containsKey(TOPOLOGY_METRIC_SAMPLE_RATE)) {
            conf.put(TOPOLOGY_METRIC_SAMPLE_RATE, sampleRate);
        }
        return sampleRate;
    }

    public static long getTimerUpdateInterval(Map conf) {
        return JStormUtils.parseLong(conf.get(TOPOLOGY_TIMER_UPDATE_INTERVAL), 10L);
    }

    public static void setTopologyTimerUpdateInterval(Map conf, long interval) {
        conf.put(TOPOLOGY_TIMER_UPDATE_INTERVAL, interval);
    }

    public static List<Integer> getCacheTimeoutList(Map conf) {
        return (List)conf.get(CACHE_TIMEOUT_LIST);
    }

    public static String getMetricUploaderClass(Map<Object, Object> conf) {
        return (String)conf.get(METRIC_UPLOADER_CLASS);
    }

    public static String getMetricQueryClientClass(Map<Object, Object> conf) {
        return (String)conf.get(METRIC_QUERY_CLIENT_CLASS);
    }

    public static Integer getTaskMsgBatchSize(Map conf) {
        return JStormUtils.parseInt(conf.get(TASK_MSG_BATCH_SIZE), 1);
    }

    public static void setTaskMsgBatchSize(Map conf, Integer batchSize) {
        conf.put(TASK_MSG_BATCH_SIZE, batchSize);
    }

    public static Boolean isTaskBatchTuple(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TASK_BATCH_TUPLE), false);
    }

    public static void setTaskBatchTuple(Map conf, boolean isBatchTuple) {
        conf.put(TASK_BATCH_TUPLE, isBatchTuple);
    }

    public static Integer getTaskMsgFlushInervalMs(Map conf) {
        return JStormUtils.parseInt(conf.get(TASK_BATCH_FLUSH_INTERVAL_MS), 2);
    }

    public static void setTaskMsgFlushInervalMs(Map conf, Integer flushMs) {
        conf.put(TASK_BATCH_FLUSH_INTERVAL_MS, flushMs);
    }

    public static void setTopologyMaxWorkerNumForNettyMetrics(Map conf, int num) {
        conf.put(TOPOLOGY_MAX_WORKER_NUM_FOR_NETTY_METRICS, num);
    }

    public static int getTopologyMaxWorkerNumForNettyMetrics(Map conf) {
        return JStormUtils.parseInt(conf.get(TOPOLOGY_MAX_WORKER_NUM_FOR_NETTY_METRICS), 100);
    }

    public static long getUiOneTablePageSize(Map conf) {
        return JStormUtils.parseLong(conf.get(UI_ONE_TABLE_PAGE_SIZE), 200L);
    }

    public static int getMaxPendingMetricNum(Map conf) {
        return JStormUtils.parseInt(conf.get(MAX_PENDING_METRIC_NUM), 200);
    }

    public static Boolean getTopologyMasterSingleWorker(Map conf) {
        Boolean ret = JStormUtils.parseBoolean(conf.get(TOPOLOGY_MASTER_SINGLE_WORKER));
        return ret;
    }

    public static double getBackpressureWaterMarkHigh(Map conf) {
        return JStormUtils.parseDouble(conf.get(TOPOLOGY_BACKPRESSURE_WATER_MARK_HIGH), 0.8);
    }

    public static double getBackpressureWaterMarkLow(Map conf) {
        return JStormUtils.parseDouble(conf.get(TOPOLOGY_BACKPRESSURE_WATER_MARK_LOW), 0.05);
    }

    public static int getBackpressureCheckIntervl(Map conf) {
        return JStormUtils.parseInt(conf.get(TOPOLOGY_BACKPRESSURE_CHECK_INTERVAL), 1000);
    }

    public static int getBackpressureTriggerSampleNumber(Map conf) {
        return JStormUtils.parseInt(conf.get(TOPOLOGY_BACKPRESSURE_TRIGGER_SAMPLE_NUMBER), 4);
    }

    public static double getBackpressureTriggerSampleRate(Map conf) {
        return JStormUtils.parseDouble(conf.get(TOPOLOGY_BACKPRESSURE_TRIGGER_SAMPLE_RATE), 0.75);
    }

    public static boolean isBackpressureEnable(Map conf) {
        return JStormUtils.parseBoolean(conf.get(TOPOLOGY_BACKPRESSURE_ENABLE), false);
    }

    public static double getBackpressureCoordinatorRatio(Map conf) {
        return JStormUtils.parseDouble(conf.get(TOPOLOGY_BACKPRESSURE_COORDINATOR_RATIO), 0.1);
    }

    public static boolean isCheckWorkerAliveBySystemInfo(Map conf) {
        return JStormUtils.parseBoolean(conf.get(SUPERVISOR_CHECK_WORKER_BY_SYSTEM_INFO), true);
    }

    public static int getTopologyTaskHbSendNumber(Map conf) {
        return JStormUtils.parseInt(conf.get(TOPOLOGY_TASK_HEARTBEAT_SEND_NUMBER), 2000);
    }

    public static boolean isProcessLauncherEnable(Map conf) {
        return JStormUtils.parseBoolean(conf.get(PROCESS_LAUNCHER_ENABLE), true);
    }

    public static int getProcessLauncherSleepSeconds(Map conf) {
        return JStormUtils.parseInt(conf.get(PROCESS_LAUNCHER_SLEEP_SECONDS), 60);
    }

    public static String getProcessLauncherChildOpts(Map conf) {
        return (String)conf.get(PROCESS_LAUNCHER_CHILDOPTS);
    }
}

