/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.client;

import backtype.storm.scheduler.WorkerSlot;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.json.simple.JSONAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerAssignment
extends WorkerSlot
implements Serializable,
JSONAware {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerAssignment.class);
    private static final long serialVersionUID = -3483047434535537861L;
    private Map<String, Integer> componentToNum = new HashMap<String, Integer>();
    private long mem;
    private int cpu;
    private String hostName;
    private String jvm;
    private static final String COMPONENTTONUM_TAG = "componentToNum";
    private static final String MEM_TAG = "mem";
    private static final String CPU_TAG = "cpu";
    private static final String HOSTNAME_TAG = "hostName";
    private static final String JVM_TAG = "jvm";
    private static final String NODEID_TAG = "nodeId";
    private static final String PORT_TAG = "port";

    public WorkerAssignment(String nodeId, Number port) {
        super(nodeId, port);
    }

    public WorkerAssignment() {
    }

    public void addComponent(String compenentName, Integer num) {
        this.componentToNum.put(compenentName, num);
    }

    public Map<String, Integer> getComponentToNum() {
        return this.componentToNum;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getJvm() {
        return this.jvm;
    }

    public long getMem() {
        return this.mem;
    }

    public void setMem(long mem) {
        this.mem = mem;
    }

    public int getCpu() {
        return this.cpu;
    }

    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    public String toJSONString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(COMPONENTTONUM_TAG, Utils.to_json(this.componentToNum));
        map.put(MEM_TAG, String.valueOf(this.mem));
        map.put(CPU_TAG, String.valueOf(this.cpu));
        map.put(HOSTNAME_TAG, this.hostName);
        map.put(JVM_TAG, this.jvm);
        map.put(NODEID_TAG, this.getNodeId());
        map.put(PORT_TAG, String.valueOf(this.getPort()));
        return Utils.to_json(map);
    }

    public static WorkerAssignment parseFromObj(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            return null;
        }
        try {
            Map map = (Map)obj;
            String supervisorId = (String)map.get(NODEID_TAG);
            String hostname = (String)map.get(HOSTNAME_TAG);
            Integer port = JStormUtils.parseInt(map.get(PORT_TAG));
            String jvm = (String)map.get(JVM_TAG);
            Long mem = JStormUtils.parseLong(map.get(MEM_TAG));
            Integer cpu = JStormUtils.parseInt(map.get(CPU_TAG));
            Map componentToNum = (Map)Utils.from_json((String)map.get(COMPONENTTONUM_TAG));
            WorkerAssignment ret = new WorkerAssignment(supervisorId, port);
            ret.hostName = hostname;
            ret.setNodeId(supervisorId);
            ret.setJvm(jvm);
            if (port != null) {
                ret.setPort(port);
            }
            if (mem != null) {
                ret.setMem(mem);
            }
            if (cpu != null) {
                ret.setCpu(cpu);
            }
            for (Map.Entry entry : componentToNum.entrySet()) {
                ret.addComponent((String)entry.getKey(), JStormUtils.parseInt(entry.getValue()));
            }
            return ret;
        }
        catch (Exception e) {
            LOG.error("Failed to convert to WorkerAssignment,  raw:" + obj, (Throwable)e);
            return null;
        }
    }

    public static String getStringFromJson(String text) {
        return text.equals("null") ? null : text;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.componentToNum == null ? 0 : this.componentToNum.hashCode());
        result2 = 31 * result2 + this.cpu;
        result2 = 31 * result2 + (this.hostName == null ? 0 : this.hostName.hashCode());
        result2 = 31 * result2 + (this.jvm == null ? 0 : this.jvm.hashCode());
        result2 = 31 * result2 + (int)(this.mem ^ this.mem >>> 32);
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkerAssignment other = (WorkerAssignment)obj;
        if (this.componentToNum == null ? other.componentToNum != null : !this.componentToNum.equals(other.componentToNum)) {
            return false;
        }
        if (this.cpu != other.cpu) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.jvm == null ? other.jvm != null : !this.jvm.equals(other.jvm)) {
            return false;
        }
        return this.mem == other.mem;
    }

    public static void main(String[] args) {
        WorkerAssignment input = new WorkerAssignment();
        input.setJvm("sb");
        input.setCpu(1);
        input.setMem(2L);
        input.addComponent("2b", 2);
        String outString = Utils.to_json(input);
        System.out.println(input);
        Object object = Utils.from_json(outString);
        System.out.println(object);
        System.out.println(WorkerAssignment.parseFromObj(object));
        System.out.print(input.equals(WorkerAssignment.parseFromObj(object)));
    }
}

