/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cluster;

import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.cluster.ClusterState;
import com.alibaba.jstorm.cluster.Common;
import com.alibaba.jstorm.cluster.StormBase;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.cluster.StormZkClusterState;
import com.alibaba.jstorm.daemon.supervisor.SupervisorInfo;
import com.alibaba.jstorm.schedule.Assignment;
import com.alibaba.jstorm.task.TaskInfo;
import com.alibaba.jstorm.task.error.TaskError;
import com.alibaba.jstorm.utils.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static Logger LOG = LoggerFactory.getLogger(Cluster.class);
    public static final String ZK_SEPERATOR = "/";
    public static final String ASSIGNMENTS_ROOT = "assignments";
    public static final String ASSIGNMENTS_BAK = "assignments_bak";
    public static final String TASKS_ROOT = "tasks";
    public static final String STORMS_ROOT = "topology";
    public static final String SUPERVISORS_ROOT = "supervisors";
    public static final String TASKBEATS_ROOT = "taskbeats";
    public static final String TASKERRORS_ROOT = "taskerrors";
    public static final String MASTER_ROOT = "nimbus_master";
    public static final String NIMBUS_SLAVE_ROOT = "nimbus_slave";
    public static final String METRIC_ROOT = "metrics";
    public static final String LAST_ERROR = "last_error";
    public static final String NIMBUS_SLAVE_DETAIL_ROOT = "nimbus_slave_detail";
    public static final String BACKPRESSURE_ROOT = "backpressure";
    public static final String ASSIGNMENTS_SUBTREE = "/assignments";
    public static final String ASSIGNMENTS_BAK_SUBTREE = "/assignments_bak";
    public static final String TASKS_SUBTREE = "/tasks";
    public static final String STORMS_SUBTREE = "/topology";
    public static final String SUPERVISORS_SUBTREE = "/supervisors";
    public static final String TASKBEATS_SUBTREE = "/taskbeats";
    public static final String TASKERRORS_SUBTREE = "/taskerrors";
    public static final String MASTER_SUBTREE = "/nimbus_master";
    public static final String NIMBUS_SLAVE_SUBTREE = "/nimbus_slave";
    public static final String METRIC_SUBTREE = "/metrics";
    public static final String NIMBUS_SLAVE_DETAIL_SUBTREE = "/nimbus_slave_detail";
    public static final String BACKPRESSURE_SUBTREE = "/backpressure";

    public static String supervisor_path(String id) {
        return SUPERVISORS_SUBTREE + ZK_SEPERATOR + id;
    }

    public static String assignment_path(String id) {
        return ASSIGNMENTS_SUBTREE + ZK_SEPERATOR + id;
    }

    public static String storm_path(String id) {
        return STORMS_SUBTREE + ZK_SEPERATOR + id;
    }

    public static String storm_task_root(String topology_id) {
        return TASKS_SUBTREE + ZK_SEPERATOR + topology_id;
    }

    public static String taskbeat_storm_root(String topology_id) {
        return TASKBEATS_SUBTREE + ZK_SEPERATOR + topology_id;
    }

    public static String taskerror_storm_root(String topology_id) {
        return TASKERRORS_SUBTREE + ZK_SEPERATOR + topology_id;
    }

    public static String lasterror_path(String topology_id) {
        return Cluster.taskerror_storm_root(topology_id) + ZK_SEPERATOR + LAST_ERROR;
    }

    public static String taskerror_path(String topology_id, int task_id) {
        return Cluster.taskerror_storm_root(topology_id) + ZK_SEPERATOR + task_id;
    }

    public static String metric_path(String topology_id) {
        return METRIC_SUBTREE + ZK_SEPERATOR + topology_id;
    }

    public static String assignment_bak_path(String id) {
        return ASSIGNMENTS_BAK_SUBTREE + ZK_SEPERATOR + id;
    }

    public static String backpressure_path(String topology_id) {
        return BACKPRESSURE_SUBTREE + ZK_SEPERATOR + topology_id;
    }

    public static StormClusterState mk_storm_cluster_state(Map cluster_state_spec) throws Exception {
        return new StormZkClusterState(cluster_state_spec);
    }

    public static StormClusterState mk_storm_cluster_state(ClusterState cluster_state_spec) throws Exception {
        return new StormZkClusterState(cluster_state_spec);
    }

    public static Map<Integer, TaskInfo> get_all_taskInfo(StormClusterState zkCluster, String topologyId) throws Exception {
        return zkCluster.task_all_info(topologyId);
    }

    public static Map<Integer, String> get_all_task_component(StormClusterState zkCluster, String topologyId, Map<Integer, TaskInfo> taskInfoMap) throws Exception {
        if (taskInfoMap == null) {
            taskInfoMap = Cluster.get_all_taskInfo(zkCluster, topologyId);
        }
        if (taskInfoMap == null) {
            return null;
        }
        return Common.getTaskToComponent(taskInfoMap);
    }

    public static Map<Integer, String> get_all_task_type(StormClusterState zkCluster, String topologyId, Map<Integer, TaskInfo> taskInfoMap) throws Exception {
        if (taskInfoMap == null) {
            taskInfoMap = Cluster.get_all_taskInfo(zkCluster, topologyId);
        }
        if (taskInfoMap == null) {
            return null;
        }
        return Common.getTaskToType(taskInfoMap);
    }

    public static String get_topology_id(StormClusterState zkCluster, String storm_name) throws Exception {
        List<String> active_storms = zkCluster.active_storms();
        String rtn = null;
        if (active_storms != null) {
            for (String topology_id : active_storms) {
                StormBase base;
                if (topology_id.indexOf(storm_name) < 0 || (base = zkCluster.storm_base(topology_id, null)) == null || !storm_name.equals(Common.getTopologyNameById(topology_id))) continue;
                rtn = topology_id;
                break;
            }
        }
        return rtn;
    }

    public static HashMap<String, StormBase> get_all_StormBase(StormClusterState zkCluster) throws Exception {
        HashMap<String, StormBase> rtn = new HashMap<String, StormBase>();
        List<String> active_storms = zkCluster.active_storms();
        if (active_storms != null) {
            for (String topology_id : active_storms) {
                StormBase base = zkCluster.storm_base(topology_id, null);
                if (base == null) continue;
                rtn.put(topology_id, base);
            }
        }
        return rtn;
    }

    public static Map<String, SupervisorInfo> get_all_SupervisorInfo(StormClusterState stormClusterState, RunnableCallback callback) throws Exception {
        TreeMap<String, SupervisorInfo> rtn = new TreeMap<String, SupervisorInfo>();
        List<String> supervisorIds = stormClusterState.supervisors(callback);
        if (supervisorIds != null) {
            for (String supervisorId : supervisorIds) {
                SupervisorInfo supervisorInfo = stormClusterState.supervisor_info(supervisorId);
                if (supervisorInfo == null) {
                    LOG.warn("Failed to get SupervisorInfo of " + supervisorId);
                    continue;
                }
                rtn.put(supervisorId, supervisorInfo);
            }
        } else {
            LOG.info("No alive supervisor");
        }
        return rtn;
    }

    public static Map<String, Assignment> get_all_assignment(StormClusterState stormClusterState, RunnableCallback callback) throws Exception {
        HashMap<String, Assignment> ret = new HashMap<String, Assignment>();
        List<String> assignments = stormClusterState.assignments(callback);
        if (assignments == null) {
            LOG.debug("No assignment of ZK");
            return ret;
        }
        for (String topology_id : assignments) {
            Assignment assignment = stormClusterState.assignment_info(topology_id, callback);
            if (assignment == null) {
                LOG.error("Failed to get Assignment of " + topology_id + " from ZK");
                continue;
            }
            ret.put(topology_id, assignment);
        }
        return ret;
    }

    public static Map<String, String> get_all_nimbus_slave(StormClusterState stormClusterState) throws Exception {
        List<String> hosts = stormClusterState.get_nimbus_slaves();
        if (hosts == null || hosts.size() == 0) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String host : hosts) {
            String time = stormClusterState.get_nimbus_slave_time(host);
            ret.put(host, time);
        }
        return ret;
    }

    public static String get_supervisor_hostname(StormClusterState stormClusterState, String supervisorId) throws Exception {
        SupervisorInfo supervisorInfo = stormClusterState.supervisor_info(supervisorId);
        if (supervisorInfo == null) {
            return null;
        }
        return supervisorInfo.getHostName();
    }

    public static boolean is_topology_exist_error(StormClusterState stormClusterState, String topologyId) throws Exception {
        Map<Integer, String> lastErrMap = stormClusterState.topo_lastErr_time(topologyId);
        if (lastErrMap == null || lastErrMap.size() == 0) {
            return false;
        }
        int now = TimeUtils.current_time_secs();
        for (Map.Entry<Integer, String> entry : lastErrMap.entrySet()) {
            Integer timeout = entry.getKey();
            Integer timestamp = Integer.valueOf(entry.getValue());
            if (now - timestamp > timeout) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, List<TaskError>> get_all_task_errors(StormClusterState stormClusterState, String topologyId) {
        HashMap<Integer, List<TaskError>> ret = new HashMap<Integer, List<TaskError>>();
        try {
            List<String> errorTasks = stormClusterState.task_error_ids(topologyId);
            if (errorTasks == null || errorTasks.size() == 0) {
                return ret;
            }
            for (String taskIdStr : errorTasks) {
                Integer taskId = -1;
                try {
                    taskId = Integer.valueOf(taskIdStr);
                }
                catch (Exception e) {
                    continue;
                }
                List<TaskError> taskErrorList = stormClusterState.task_errors(topologyId, taskId);
                ret.put(taskId, taskErrorList);
            }
            return ret;
        }
        catch (Exception e) {
            return ret;
        }
    }
}

