/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cluster;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.InvalidTopologyException;
import backtype.storm.generated.JavaObject;
import backtype.storm.generated.ShellComponent;
import backtype.storm.generated.SpoutSpec;
import backtype.storm.generated.StateSpoutSpec;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.StreamInfo;
import backtype.storm.metric.SystemBolt;
import backtype.storm.spout.ShellSpout;
import backtype.storm.task.ShellBolt;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.ThriftTopologyUtils;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.schedule.default_assign.DefaultTopologyAssignContext;
import com.alibaba.jstorm.task.TaskInfo;
import com.alibaba.jstorm.task.acker.Acker;
import com.alibaba.jstorm.task.group.MkGrouper;
import com.alibaba.jstorm.task.master.TopologyMaster;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.Thrift;
import com.alibaba.jstorm.utils.TimeUtils;
import com.google.common.collect.Maps;
import java.net.URLClassLoader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    private static final Logger LOG = LoggerFactory.getLogger(Common.class);
    public static final String TOPOLOGY_MASTER_COMPONENT_ID = "__topology_master";
    public static final String TOPOLOGY_MASTER_HB_STREAM_ID = "__master_task_heartbeat";
    public static final String TOPOLOGY_MASTER_METRICS_STREAM_ID = "__master_metrics";
    public static final String TOPOLOGY_MASTER_CONTROL_STREAM_ID = "__master_control_stream";
    public static final String ACKER_COMPONENT_ID = "__acker";
    public static final String ACKER_INIT_STREAM_ID = "__ack_init";
    public static final String ACKER_ACK_STREAM_ID = "__ack_ack";
    public static final String ACKER_FAIL_STREAM_ID = "__ack_fail";
    public static final String SYSTEM_STREAM_ID = "__system";
    public static final String LS_WORKER_HEARTBEAT = "worker-heartbeat";
    public static final String LS_ID = "supervisor-id";
    public static final String LS_LOCAL_ASSIGNMENTS = "local-assignments";
    public static final String LS_LOCAl_ZK_ASSIGNMENTS = "local-zk-assignments";
    public static final String LS_LOCAL_ZK_ASSIGNMENT_VERSION = "lcoal-zk-assignment-version";
    public static final String LS_APPROVED_WORKERS = "approved-workers";
    public static final String LS_TASK_CLEANUP_TIMEOUT = "task-cleanup-timeout";
    public static final String compErrorInfo = "ID can only contains a-z, A-Z, 0-9, '-', '_', '.', '$', and should not start with \"__\".";
    public static final String nameErrorInfo = "Name can only contains a-z, A-Z, 0-9, '-', '_', '.'";
    private static List<String> sysEventFields = JStormUtils.mk_list("event");

    public static boolean system_id(String id) {
        return Utils.isSystemId(id);
    }

    private static void validate_component(Object obj) throws InvalidTopologyException {
        if (obj instanceof StateSpoutSpec) {
            StateSpoutSpec spec = (StateSpoutSpec)obj;
            for (String id : spec.get_common().get_streams().keySet()) {
                if (!Common.system_id(id) && Common.charComponentValidate(id)) continue;
                throw new InvalidTopologyException(id + " is not a valid component id. " + compErrorInfo);
            }
        } else if (obj instanceof SpoutSpec) {
            SpoutSpec spec = (SpoutSpec)obj;
            for (String id : spec.get_common().get_streams().keySet()) {
                if (!Common.system_id(id) && Common.charComponentValidate(id)) continue;
                throw new InvalidTopologyException(id + " is not a valid component id. " + compErrorInfo);
            }
        } else if (obj instanceof Bolt) {
            Bolt spec = (Bolt)obj;
            for (String id : spec.get_common().get_streams().keySet()) {
                if (!Common.system_id(id) && Common.charComponentValidate(id)) continue;
                throw new InvalidTopologyException(id + " is not a valid component id. " + compErrorInfo);
            }
        } else {
            throw new InvalidTopologyException("Unknow type component");
        }
    }

    public static String topologyNameToId(String topologyName, int counter) {
        return topologyName + "-" + counter + "-" + TimeUtils.current_time_secs();
    }

    public static String getTopologyNameById(String topologyId) {
        String topologyName = null;
        try {
            topologyName = Common.topologyIdToName(topologyId);
        }
        catch (InvalidTopologyException e) {
            LOG.error("Invalid topologyId=" + topologyId);
        }
        return topologyName;
    }

    public static String topologyIdToName(String topologyId) throws InvalidTopologyException {
        String ret = null;
        int index = topologyId.lastIndexOf(45);
        if (index != -1 && index > 2) {
            if ((index = topologyId.lastIndexOf(45, index - 1)) == -1 || index <= 0) {
                throw new InvalidTopologyException(topologyId + " is not a valid topologyId");
            }
        } else {
            throw new InvalidTopologyException(topologyId + " is not a valid topologyId");
        }
        ret = topologyId.substring(0, index);
        return ret;
    }

    public static boolean charValidate(String name) {
        return name.matches("[a-zA-Z0-9-_.]+");
    }

    public static boolean charComponentValidate(String name) {
        return name.matches("[a-zA-Z0-9-_/.$]+");
    }

    public static void validate_ids(StormTopology topology, String topologyId) throws InvalidTopologyException {
        String topologyName = Common.topologyIdToName(topologyId);
        if (!Common.charValidate(topologyName)) {
            throw new InvalidTopologyException(topologyName + " is not a valid topology name. " + nameErrorInfo);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (StormTopology._Fields field : Thrift.STORM_TOPOLOGY_FIELDS) {
            Object value = topology.getFieldValue(field);
            if (value == null) continue;
            Map obj_map = (Map)value;
            Set commids = obj_map.keySet();
            for (String id : commids) {
                if (!Common.system_id(id) && Common.charComponentValidate(id)) continue;
                throw new InvalidTopologyException(id + " is not a valid component id. " + compErrorInfo);
            }
            for (Object obj : obj_map.values()) {
                Common.validate_component(obj);
            }
            list2.addAll(commids);
        }
        List<String> offending = JStormUtils.getRepeat(list2);
        if (!offending.isEmpty()) {
            throw new InvalidTopologyException("Duplicate component ids: " + offending);
        }
    }

    private static void validate_component_inputs(Object obj) throws InvalidTopologyException {
        Comparable<StateSpoutSpec> spec;
        if (obj instanceof StateSpoutSpec && !((StateSpoutSpec)(spec = (StateSpoutSpec)obj)).get_common().get_inputs().isEmpty()) {
            throw new InvalidTopologyException("May not declare inputs for a spout");
        }
        if (obj instanceof SpoutSpec && !((SpoutSpec)(spec = (SpoutSpec)obj)).get_common().get_inputs().isEmpty()) {
            throw new InvalidTopologyException("May not declare inputs for a spout");
        }
    }

    public static void validate_basic(StormTopology topology, Map<Object, Object> totalStormConf, String topologyid) throws InvalidTopologyException {
        Common.validate_ids(topology, topologyid);
        for (StormTopology._Fields field : Thrift.SPOUT_FIELDS) {
            Object value = topology.getFieldValue(field);
            if (value == null) continue;
            Map obj_map = (Map)value;
            for (Object obj : obj_map.values()) {
                Common.validate_component_inputs(obj);
            }
        }
        Integer workerNum = JStormUtils.parseInt(totalStormConf.get("topology.workers"));
        if (workerNum == null || workerNum <= 0) {
            String errMsg = "There are no Config.TOPOLOGY_WORKERS in configuration of " + topologyid;
            throw new InvalidParameterException(errMsg);
        }
        Integer ackerNum = JStormUtils.parseInt(totalStormConf.get("topology.acker.executors"));
        if (ackerNum != null && ackerNum < 0) {
            String errMsg = "Invalide Config.TOPOLOGY_ACKERS in configuration of " + topologyid;
            throw new InvalidParameterException(errMsg);
        }
    }

    public static Map<GlobalStreamId, Grouping> topoMasterInputs(StormTopology topology) {
        GlobalStreamId stream = null;
        Grouping group = null;
        HashMap<GlobalStreamId, Grouping> spout_inputs = new HashMap<GlobalStreamId, Grouping>();
        Map<String, SpoutSpec> spout_ids = topology.get_spouts();
        for (Map.Entry<String, SpoutSpec> spout : spout_ids.entrySet()) {
            String id = spout.getKey();
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_HB_STREAM_ID);
            group = Thrift.mkAllGrouping();
            spout_inputs.put(stream, group);
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_METRICS_STREAM_ID);
            group = Thrift.mkAllGrouping();
            spout_inputs.put(stream, group);
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_CONTROL_STREAM_ID);
            group = Thrift.mkAllGrouping();
            spout_inputs.put(stream, group);
        }
        Map<String, Bolt> bolt_ids = topology.get_bolts();
        HashMap<GlobalStreamId, Grouping> bolt_inputs = new HashMap<GlobalStreamId, Grouping>();
        for (Map.Entry<String, Bolt> bolt : bolt_ids.entrySet()) {
            String id = bolt.getKey();
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_HB_STREAM_ID);
            group = Thrift.mkAllGrouping();
            bolt_inputs.put(stream, group);
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_METRICS_STREAM_ID);
            group = Thrift.mkAllGrouping();
            bolt_inputs.put(stream, group);
            stream = new GlobalStreamId(id, TOPOLOGY_MASTER_CONTROL_STREAM_ID);
            group = Thrift.mkAllGrouping();
            bolt_inputs.put(stream, group);
        }
        HashMap<GlobalStreamId, Grouping> himself_inputs = new HashMap<GlobalStreamId, Grouping>();
        stream = new GlobalStreamId(TOPOLOGY_MASTER_COMPONENT_ID, TOPOLOGY_MASTER_HB_STREAM_ID);
        group = Thrift.mkAllGrouping();
        himself_inputs.put(stream, group);
        stream = new GlobalStreamId(TOPOLOGY_MASTER_COMPONENT_ID, TOPOLOGY_MASTER_METRICS_STREAM_ID);
        group = Thrift.mkAllGrouping();
        himself_inputs.put(stream, group);
        HashMap<GlobalStreamId, Grouping> allInputs = new HashMap<GlobalStreamId, Grouping>();
        allInputs.putAll(bolt_inputs);
        allInputs.putAll(spout_inputs);
        allInputs.putAll(himself_inputs);
        return allInputs;
    }

    public static void addTopologyMaster(Map stormConf, StormTopology ret) {
        GlobalStreamId stream;
        List<String> fields;
        ComponentCommon common;
        HashMap<String, StreamInfo> outputs = new HashMap<String, StreamInfo>();
        List<String> list2 = JStormUtils.mk_list("ctrlEvent");
        outputs.put(TOPOLOGY_MASTER_CONTROL_STREAM_ID, Thrift.outputFields(list2));
        list2 = JStormUtils.mk_list("worker", "metrics");
        outputs.put(TOPOLOGY_MASTER_METRICS_STREAM_ID, Thrift.outputFields(list2));
        list2 = JStormUtils.mk_list("hbEvent");
        outputs.put(TOPOLOGY_MASTER_HB_STREAM_ID, Thrift.outputFields(list2));
        TopologyMaster topologyMaster = new TopologyMaster();
        Map<GlobalStreamId, Grouping> inputs = Common.topoMasterInputs(ret);
        Bolt topologyMasterBolt = Thrift.mkBolt(inputs, topologyMaster, outputs, 1);
        for (Map.Entry<String, Bolt> entry : ret.get_bolts().entrySet()) {
            Bolt bolt = entry.getValue();
            common = bolt.get_common();
            fields = JStormUtils.mk_list("worker", "metrics");
            common.put_to_streams(TOPOLOGY_MASTER_METRICS_STREAM_ID, Thrift.directOutputFields(fields));
            fields = JStormUtils.mk_list("hbEvent");
            common.put_to_streams(TOPOLOGY_MASTER_HB_STREAM_ID, Thrift.directOutputFields(fields));
            fields = JStormUtils.mk_list("ctrlEvent");
            common.put_to_streams(TOPOLOGY_MASTER_CONTROL_STREAM_ID, Thrift.directOutputFields(fields));
            stream = new GlobalStreamId(TOPOLOGY_MASTER_COMPONENT_ID, TOPOLOGY_MASTER_CONTROL_STREAM_ID);
            common.put_to_inputs(stream, Thrift.mkDirectGrouping());
            bolt.set_common(common);
        }
        for (Map.Entry<String, Comparable<Bolt>> entry : ret.get_spouts().entrySet()) {
            SpoutSpec spout = (SpoutSpec)entry.getValue();
            common = spout.get_common();
            fields = JStormUtils.mk_list("worker", "metrics");
            common.put_to_streams(TOPOLOGY_MASTER_METRICS_STREAM_ID, Thrift.directOutputFields(fields));
            fields = JStormUtils.mk_list("hbEvent");
            common.put_to_streams(TOPOLOGY_MASTER_HB_STREAM_ID, Thrift.directOutputFields(fields));
            fields = JStormUtils.mk_list("ctrlEvent");
            common.put_to_streams(TOPOLOGY_MASTER_CONTROL_STREAM_ID, Thrift.directOutputFields(fields));
            stream = new GlobalStreamId(TOPOLOGY_MASTER_COMPONENT_ID, TOPOLOGY_MASTER_CONTROL_STREAM_ID);
            common.put_to_inputs(stream, Thrift.mkDirectGrouping());
            spout.set_common(common);
        }
        ret.put_to_bolts(TOPOLOGY_MASTER_COMPONENT_ID, topologyMasterBolt);
    }

    public static Map<GlobalStreamId, Grouping> acker_inputs(StormTopology topology) {
        HashMap<GlobalStreamId, Grouping> spout_inputs = new HashMap<GlobalStreamId, Grouping>();
        Map<String, SpoutSpec> spout_ids = topology.get_spouts();
        for (Map.Entry<String, SpoutSpec> spout : spout_ids.entrySet()) {
            String id = spout.getKey();
            GlobalStreamId stream = new GlobalStreamId(id, ACKER_INIT_STREAM_ID);
            Grouping group = Thrift.mkFieldsGrouping(JStormUtils.mk_list("id"));
            spout_inputs.put(stream, group);
        }
        Map<String, Bolt> bolt_ids = topology.get_bolts();
        HashMap<GlobalStreamId, Grouping> bolt_inputs = new HashMap<GlobalStreamId, Grouping>();
        for (Map.Entry<String, Bolt> bolt : bolt_ids.entrySet()) {
            String id = bolt.getKey();
            GlobalStreamId streamAck = new GlobalStreamId(id, ACKER_ACK_STREAM_ID);
            Grouping groupAck = Thrift.mkFieldsGrouping(JStormUtils.mk_list("id"));
            GlobalStreamId streamFail = new GlobalStreamId(id, ACKER_FAIL_STREAM_ID);
            Grouping groupFail = Thrift.mkFieldsGrouping(JStormUtils.mk_list("id"));
            bolt_inputs.put(streamAck, groupAck);
            bolt_inputs.put(streamFail, groupFail);
        }
        HashMap<GlobalStreamId, Grouping> allInputs = new HashMap<GlobalStreamId, Grouping>();
        allInputs.putAll(bolt_inputs);
        allInputs.putAll(spout_inputs);
        return allInputs;
    }

    public static void add_acker(Map stormConf, StormTopology ret) {
        ComponentCommon common;
        Comparable<Bolt> bolt;
        String key = "topology.acker.executors";
        Integer ackerNum = JStormUtils.parseInt(stormConf.get(key), 0);
        HashMap<String, StreamInfo> outputs = new HashMap<String, StreamInfo>();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        outputs.put(ACKER_ACK_STREAM_ID, Thrift.directOutputFields(fields));
        outputs.put(ACKER_FAIL_STREAM_ID, Thrift.directOutputFields(fields));
        Acker ackerbolt = new Acker();
        Map<GlobalStreamId, Grouping> inputs = Common.acker_inputs(ret);
        Bolt acker_bolt = Thrift.mkBolt(inputs, ackerbolt, outputs, ackerNum);
        for (Map.Entry<String, Bolt> entry : ret.get_bolts().entrySet()) {
            bolt = entry.getValue();
            common = ((Bolt)bolt).get_common();
            List<String> ackList = JStormUtils.mk_list("id", "ack-val");
            common.put_to_streams(ACKER_ACK_STREAM_ID, Thrift.outputFields(ackList));
            List<String> failList = JStormUtils.mk_list("id");
            common.put_to_streams(ACKER_FAIL_STREAM_ID, Thrift.outputFields(failList));
            ((Bolt)bolt).set_common(common);
        }
        for (Map.Entry<String, Comparable<Bolt>> entry : ret.get_spouts().entrySet()) {
            bolt = (SpoutSpec)entry.getValue();
            common = ((SpoutSpec)bolt).get_common();
            List<String> initList = JStormUtils.mk_list("id", "init-val", "spout-task");
            common.put_to_streams(ACKER_INIT_STREAM_ID, Thrift.outputFields(initList));
            GlobalStreamId ack_ack = new GlobalStreamId(ACKER_COMPONENT_ID, ACKER_ACK_STREAM_ID);
            common.put_to_inputs(ack_ack, Thrift.mkDirectGrouping());
            GlobalStreamId ack_fail = new GlobalStreamId(ACKER_COMPONENT_ID, ACKER_FAIL_STREAM_ID);
            common.put_to_inputs(ack_fail, Thrift.mkDirectGrouping());
        }
        ret.put_to_bolts(ACKER_COMPONENT_ID, acker_bolt);
    }

    public static List<Object> all_components(StormTopology topology) {
        ArrayList<Object> rtn = new ArrayList<Object>();
        for (StormTopology._Fields field : Thrift.STORM_TOPOLOGY_FIELDS) {
            Object fields = topology.getFieldValue(field);
            if (fields == null) continue;
            rtn.addAll(((Map)fields).values());
        }
        return rtn;
    }

    private static void add_component_system_streams(Object obj) {
        Comparable<StateSpoutSpec> spec;
        ComponentCommon common = null;
        if (obj instanceof StateSpoutSpec) {
            spec = (StateSpoutSpec)obj;
            common = ((StateSpoutSpec)spec).get_common();
        }
        if (obj instanceof SpoutSpec) {
            spec = (SpoutSpec)obj;
            common = ((SpoutSpec)spec).get_common();
        }
        if (obj instanceof Bolt) {
            spec = (Bolt)obj;
            common = ((Bolt)spec).get_common();
        }
        if (common != null) {
            StreamInfo sinfo = Thrift.outputFields(sysEventFields);
            common.put_to_streams(SYSTEM_STREAM_ID, sinfo);
        }
    }

    public static void add_system_streams(StormTopology topology) {
        for (Object obj : Common.all_components(topology)) {
            Common.add_component_system_streams(obj);
        }
    }

    public static StormTopology add_system_components(StormTopology topology) {
        HashMap<GlobalStreamId, Grouping> inputs = new HashMap<GlobalStreamId, Grouping>();
        HashMap<String, StreamInfo> outputs = new HashMap<String, StreamInfo>();
        ArrayList fields = new ArrayList();
        outputs.put("__tick", Thrift.outputFields(JStormUtils.mk_list("rate_secs")));
        outputs.put("__metrics_tick", Thrift.outputFields(JStormUtils.mk_list("interval")));
        outputs.put("__credentials", Thrift.outputFields(JStormUtils.mk_list("creds")));
        SystemBolt ackerbolt = new SystemBolt();
        Bolt bolt = Thrift.mkBolt(inputs, ackerbolt, outputs, 0);
        topology.put_to_bolts(SYSTEM_STREAM_ID, bolt);
        Common.add_system_streams(topology);
        return topology;
    }

    public static StormTopology add_metrics_component(StormTopology topology) {
        return topology;
    }

    public static StormTopology system_topology(Map storm_conf, StormTopology topology) throws InvalidTopologyException {
        StormTopology ret = topology.deepCopy();
        Common.add_acker(storm_conf, ret);
        if (!StormConfig.local_mode(storm_conf)) {
            Common.addTopologyMaster(storm_conf, ret);
        }
        Common.add_metrics_component(ret);
        Common.add_system_components(ret);
        return ret;
    }

    public static Map component_conf(Map storm_conf, TopologyContext topology_context, String component_id) {
        List<Object> to_remove = StormConfig.All_CONFIGS();
        to_remove.remove("topology.debug");
        to_remove.remove("topology.max.spout.pending");
        to_remove.remove("topology.max.task.parallelism");
        to_remove.remove("topology.transactional.id");
        Map componentConf = new HashMap();
        String jconf = topology_context.getComponentCommon(component_id).get_json_conf();
        if (jconf != null) {
            componentConf = (Map)JStormUtils.from_json(jconf);
        }
        HashMap ret = new HashMap();
        ret.putAll(storm_conf);
        ret.putAll(componentConf);
        return ret;
    }

    public static Object get_task_object(StormTopology topology, String component_id, URLClassLoader loader) {
        Map<String, SpoutSpec> spouts = topology.get_spouts();
        Map<String, Bolt> bolts = topology.get_bolts();
        Map<String, StateSpoutSpec> state_spouts = topology.get_state_spouts();
        ComponentObject obj = null;
        if (spouts.containsKey(component_id)) {
            obj = spouts.get(component_id).get_spout_object();
        } else if (bolts.containsKey(component_id)) {
            obj = bolts.get(component_id).get_bolt_object();
        } else if (state_spouts.containsKey(component_id)) {
            obj = state_spouts.get(component_id).get_state_spout_object();
        }
        if (obj == null) {
            throw new RuntimeException("Could not find " + component_id + " in " + topology.toString());
        }
        Object componentObject = Utils.getSetComponentObject(obj, loader);
        Object rtn = null;
        rtn = componentObject instanceof JavaObject ? Thrift.instantiateJavaObject((JavaObject)componentObject) : (componentObject instanceof ShellComponent ? (spouts.containsKey(component_id) ? new ShellSpout((ShellComponent)componentObject) : new ShellBolt((ShellComponent)componentObject)) : componentObject);
        return rtn;
    }

    public static Map<String, Map<String, MkGrouper>> outbound_components(TopologyContext topology_context, WorkerData workerData) {
        HashMap<String, Map<String, MkGrouper>> rr = new HashMap<String, Map<String, MkGrouper>>();
        Map<String, Map<String, Grouping>> output_groupings = topology_context.getThisTargets();
        for (Map.Entry<String, Map<String, Grouping>> entry : output_groupings.entrySet()) {
            String stream_id = entry.getKey();
            Map<String, Grouping> component_grouping = entry.getValue();
            Fields out_fields = topology_context.getThisOutputFields(stream_id);
            HashMap<String, MkGrouper> componentGrouper = new HashMap<String, MkGrouper>();
            for (Map.Entry<String, Grouping> cg : component_grouping.entrySet()) {
                String component = cg.getKey();
                Grouping tgrouping = cg.getValue();
                List<Integer> outTasks = topology_context.getComponentTasks(component);
                if (outTasks.size() > 0) {
                    MkGrouper grouper = new MkGrouper(topology_context, out_fields, tgrouping, outTasks, stream_id, workerData);
                    componentGrouper.put(component, grouper);
                }
                LOG.info("outbound_components, outTasks=" + outTasks + " for task-" + topology_context.getThisTaskId());
            }
            if (componentGrouper.size() <= 0) continue;
            rr.put(stream_id, componentGrouper);
        }
        return rr;
    }

    public static Map getComponentMap(DefaultTopologyAssignContext context, Integer task) {
        String componentName = context.getTaskToComponent().get(task);
        ComponentCommon componentCommon = ThriftTopologyUtils.getComponentCommon(context.getSysTopology(), componentName);
        Map componentMap = (Map)JStormUtils.from_json(componentCommon.get_json_conf());
        if (componentMap == null) {
            componentMap = Maps.newHashMap();
        }
        return componentMap;
    }

    public static Map<String, Set<String>> buildSpoutOutoputAndBoltInputMap(DefaultTopologyAssignContext context) {
        Set<String> bolts = context.getRawTopology().get_bolts().keySet();
        Set<String> spouts = context.getRawTopology().get_spouts().keySet();
        HashMap<String, Set<String>> relationship = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Bolt> entry : context.getRawTopology().get_bolts().entrySet()) {
            Map<GlobalStreamId, Grouping> inputs = entry.getValue().get_common().get_inputs();
            HashSet<String> input = new HashSet<String>();
            relationship.put(entry.getKey(), input);
            for (Map.Entry<GlobalStreamId, Grouping> inEntry : inputs.entrySet()) {
                String component = inEntry.getKey().get_componentId();
                input.add(component);
                if (bolts.contains(component)) continue;
                HashSet<String> spoutOutput = (HashSet<String>)relationship.get(component);
                if (spoutOutput == null) {
                    spoutOutput = new HashSet<String>();
                    relationship.put(component, spoutOutput);
                }
                spoutOutput.add(entry.getKey());
            }
        }
        for (String spout : spouts) {
            if (relationship.get(spout) != null) continue;
            relationship.put(spout, new HashSet());
        }
        for (String bolt : bolts) {
            if (relationship.get(bolt) != null) continue;
            relationship.put(bolt, new HashSet());
        }
        return relationship;
    }

    public static Map<Integer, String> getTaskToComponent(Map<Integer, TaskInfo> taskInfoMap) {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, TaskInfo> entry : taskInfoMap.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getComponentId());
        }
        return ret;
    }

    public static Map<Integer, String> getTaskToType(Map<Integer, TaskInfo> taskInfoMap) {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        for (Map.Entry<Integer, TaskInfo> entry : taskInfoMap.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().getComponentType());
        }
        return ret;
    }

    public static Integer mkTaskMaker(Map<Object, Object> stormConf, Map<String, ?> cidSpec, Map<Integer, TaskInfo> rtn, Integer cnt) {
        if (cidSpec == null) {
            LOG.warn("Component map is empty");
            return cnt;
        }
        Set<Map.Entry<String, ?>> entrySet = cidSpec.entrySet();
        for (Map.Entry<String, ?> entry : entrySet) {
            Object obj = entry.getValue();
            ComponentCommon common = null;
            String componentType = "bolt";
            if (obj instanceof Bolt) {
                common = ((Bolt)obj).get_common();
                componentType = "bolt";
            } else if (obj instanceof SpoutSpec) {
                common = ((SpoutSpec)obj).get_common();
                componentType = "spout";
            } else if (obj instanceof StateSpoutSpec) {
                common = ((StateSpoutSpec)obj).get_common();
                componentType = "spout";
            }
            if (common == null) {
                throw new RuntimeException("No ComponentCommon of " + entry.getKey());
            }
            int declared = Thrift.parallelismHint(common);
            Integer parallelism = declared;
            HashMap<Object, Object> newStormConf = new HashMap<Object, Object>(stormConf);
            Integer maxParallelism = JStormUtils.parseInt(newStormConf.get("topology.max.task.parallelism"));
            if (maxParallelism != null) {
                parallelism = Math.min(maxParallelism, declared);
            }
            for (int i = 0; i < parallelism; ++i) {
                Integer n = cnt;
                Integer n2 = cnt = Integer.valueOf(cnt + 1);
                TaskInfo taskInfo = new TaskInfo(entry.getKey(), componentType);
                rtn.put(cnt, taskInfo);
            }
        }
        return cnt;
    }

    public static Map<Integer, TaskInfo> mkTaskInfo(Map<Object, Object> stormConf, StormTopology sysTopology, String topologyid) {
        TreeMap<Integer, TaskInfo> rtn = new TreeMap<Integer, TaskInfo>();
        Integer count = 0;
        count = Common.mkTaskMaker(stormConf, sysTopology.get_bolts(), rtn, count);
        count = Common.mkTaskMaker(stormConf, sysTopology.get_spouts(), rtn, count);
        count = Common.mkTaskMaker(stormConf, sysTopology.get_state_spouts(), rtn, count);
        return rtn;
    }

    public static boolean isSystemComponent(String componentId) {
        return componentId.equals(ACKER_COMPONENT_ID) || componentId.equals(TOPOLOGY_MASTER_COMPONENT_ID);
    }
}

