/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.cluster;

import com.alibaba.jstorm.cluster.StormStatus;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StormBase
implements Serializable {
    private static final long serialVersionUID = -3013095336395395213L;
    private String stormName;
    private int lanchTimeSecs;
    private StormStatus status;
    private boolean enableMonitor = true;
    private String group;

    public StormBase(String stormName, int lanchTimeSecs, StormStatus status, String group) {
        this.stormName = stormName;
        this.lanchTimeSecs = lanchTimeSecs;
        this.status = status;
        this.setGroup(group);
    }

    public String getStormName() {
        return this.stormName;
    }

    public void setStormName(String stormName) {
        this.stormName = stormName;
    }

    public int getLanchTimeSecs() {
        return this.lanchTimeSecs;
    }

    public void setLanchTimeSecs(int lanchTimeSecs) {
        this.lanchTimeSecs = lanchTimeSecs;
    }

    public StormStatus getStatus() {
        return this.status;
    }

    public void setStatus(StormStatus status) {
        this.status = status;
    }

    public String getStatusString() {
        StatusType t = this.status.getStatusType();
        return t.getStatus().toUpperCase();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isEnableMonitor() {
        return this.enableMonitor;
    }

    public void setEnableMonitor(boolean enableMonitor) {
        this.enableMonitor = enableMonitor;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.enableMonitor ? 1231 : 1237);
        result2 = 31 * result2 + (this.group == null ? 0 : this.group.hashCode());
        result2 = 31 * result2 + this.lanchTimeSecs;
        result2 = 31 * result2 + (this.status == null ? 0 : this.status.hashCode());
        result2 = 31 * result2 + (this.stormName == null ? 0 : this.stormName.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StormBase other = (StormBase)obj;
        if (this.enableMonitor != other.enableMonitor) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.lanchTimeSecs != other.lanchTimeSecs) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.stormName == null ? other.stormName != null : !this.stormName.equals(other.stormName));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

