/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.common.metric;

import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.snapshot.AsmCounterSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmSnapshot;
import com.codahale.metrics.Counter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsmCounter
extends AsmMetric<Counter> {
    private final Map<Integer, Counter> counterMap = new ConcurrentHashMap<Integer, Counter>();
    private Counter unFlushed = new Counter();

    public AsmCounter() {
        Iterator i$ = windowSeconds.iterator();
        while (i$.hasNext()) {
            int win = (Integer)i$.next();
            this.counterMap.put(win, new Counter());
        }
    }

    public void inc() {
        this.update(1);
    }

    @Override
    public void update(Number val) {
        this.unFlushed.inc(val.longValue());
    }

    @Override
    public void updateTime(long obj) {
        throw new RuntimeException("please use update method!");
    }

    @Override
    protected void doFlush() {
        long v = this.unFlushed.getCount();
        for (Counter counter : this.counterMap.values()) {
            counter.inc(v);
        }
        for (AsmMetric assocMetric : this.assocMetrics) {
            assocMetric.updateDirectly(v);
        }
        this.unFlushed.dec(v);
    }

    @Override
    public Map<Integer, Counter> getWindowMetricMap() {
        return this.counterMap;
    }

    @Override
    public Counter mkInstance() {
        return new Counter();
    }

    @Override
    protected void updateSnapshot(int window) {
        Counter counter = this.counterMap.get(window);
        if (counter != null) {
            AsmSnapshot snapshot = new AsmCounterSnapshot().setValue(counter.getCount()).setTs(System.currentTimeMillis()).setMetricId(this.metricId);
            this.snapshots.put(window, snapshot);
        }
    }

    @Override
    public AsmMetric clone() {
        return new AsmCounter();
    }
}

